#include <stdio.h>

#define DIM 4
#define MNF 20

int isolv4x3(int a[], int s[])
{
    int i, j, k, tmp, g;

    for(i = 0; i < 3; i++) {
        for(j = i; j < 3; j++) if(a[j * DIM + i] != 0) break;
	if(j == 3) return 0;
	if(j > i) {
	    for(k = i; k < DIM; k++) {
	        tmp = a[i * DIM + k];
		a[i * DIM + k] = a[j * DIM + k];
		a[j * DIM + k] = tmp;
	    }
	}
	for(j = i + 1; j < 3; j++) {
	    for(k = i + 1; k < DIM; k++) {
	        a[j * DIM + k] *= a[i * DIM + i];
		a[j * DIM + k] -= a[j * DIM + i] * a[i * DIM + k];
	    }
	    g = gcd(a[j * DIM + i + 1], a[j * DIM + i + 2]);
	    for(k = i + 3; k < DIM; k++) g = gcd(g, a[j * DIM + k]);
	    for(k = i + 1; k < DIM; k++) a[j * DIM + k] /= g;
	}
    }
    s[3] = a[2 * DIM + 2];
    s[2] = -a[2 * DIM + 3];
    tmp = s[2] * a[DIM + 2] + s[3] * a[DIM + 3];
    g = gcd(tmp, a[DIM + 1]);
    s[1] = -tmp / g;
    s[2] *= a[DIM + 1] / g;
    s[3] *= a[DIM + 1] / g;
    tmp = s[1] * a[1] + s[2] * a[2] + s[3] * a[3];
    g = gcd(tmp, a[0]);
    s[0] = -tmp / g;
    s[1] *= a[0] / g;
    s[2] *= a[0] / g;
    s[3] *= a[0] / g;
    if(s[DIM - 1] < 0) for(k = 0; k < DIM; k++) s[k] *= -1;
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, k, n, a[3 * DIM], c[DIM], s[DIM], v[MNF * DIM], m[MNF];

    for (j = 0; j < DIM; j++) scanf("%d", c + j);
    scanf("%d", &n);
    if((n < 3) || (n > MNF)) return 0;
    for(i = 0; i < n; i++) {
        for (j = 0; j < DIM; j++) scanf("%d", v + DIM * i + j);
	for (j = 0; j < DIM - 1; j++) v[i * DIM + j] *= -c[j];
	v[i * DIM + j] *= c[j];
    }
    /*
    for(i = 0; i < n; i++) {
        for(j = 0; j < DIM; j++) printf("%d ", v[i * DIM + j]);
	printf("\n");
    }
    */
    for(j = 0; j < 3; j++) m[j] = j;
    m[3] = n;
    for( ; ; ) {
        for(i = 0; i < 3; i++) {
	  for(j = 0; j < DIM; j++) a[i * DIM + j] = v[m[i] * DIM + j];
	}
	if(isolv4x3(a, s) == 1) {
	    for(i = 0; i < n; i++) {
	        int sum = 0;
		for(j = 0; j < DIM; j++) sum += s[j] * v[i * DIM + j];
		if(sum < 0) break;
	    }
	    if(i == n) {
	        int sum = 0;
		printf("(%d %d %d %d) [", s[0], s[1], s[2], s[3]);
		for(j = 0; j < 3; j++) printf("%d ", m[j]);
		printf("]   ");
		for(j = 0; j < DIM - 1; j++) sum -= c[j] * s[j] * s[j];
		sum += c[j] *s[j] * s[j];
		if(sum < 0) printf("Out of C\n");
		else if(sum > 0) printf("Inside of C\n");
		else printf("Boundary of C\n");
	    }
	}
	for(k = 2; k >= 0; k--) if(m[k] + 1 < m[k + 1]) break;
	if(k < 0) break;
	m[k]++;
	for(k++; k < 3; k++) m[k] = m[k - 1] + 1;
    }
    return 0;
}
