#include <stdio.h>
#include <stdlib.h>
#include <math.h>

void f(double t, double *x, double *y)
{
    if(t < .25) {
        *x = 15. * cos(6 * (t - 1. / 12.) * M_PI);
	*y = 15. * sin(6 * (t - 1. / 12.) * M_PI);
    }
    else if(t < .75) {
        *x = -4. + 11. * cos(2. * (t + .25) * M_PI);
        *y = 11. * sin(2. * (t + .25) * M_PI);
    }
    else if(t < 7. / 8.) {
        *x = 10. + 3. * cos(8. * (-t + 7. / 8.) * M_PI);
        *y = 3. * sin(8. * (-t + 7. / 8.) * M_PI);
    }
    else if(t < 15. / 16.) {
        *x = 13.;
	*y = -32. * (t - 7. / 8.);
    }
    else {
        *x = 13. * cos(8. * (-t + 15. / 16.) * M_PI);
        *y = -2. + 13. * sin(8. * (-t + 15. / 16.) * M_PI);
    }
}

void h(double t, double *x, double *y)
{
    if(t < 1. / 8.) {
        *x = 80. * t;
	*y = -15. + 104. * t;
    }
    else if(t < 3. / 20.) {
        *x = 10. + 2. * cos((80. * t - 10.5) * M_PI);
	*y = 2. * sin((80. * t - 10.5) * M_PI);
    }
    else if(t < 13. / 80.) {
        *x = -800. * t + 130.;
	*y = -1040. * t + 154.;
    }
    else if(t < 7. / 40.) {
        *x = 0.;
	*y = 1040. * t - 184.;
    }
    else if(t < 1. / 5.) {
        *x = 2. * cos((80. * t - 14.5) * M_PI);
	*y = 2. * sin((80. * t - 14.5) * M_PI);
    }
    else if(t < 17. / 80.) {
        *x = 0;
	*y = -1040. * t + 206.;
    }
    else if(t < 9. / 40.) {
        *x = -800. * t + 170.;
	*y = 1040. * t - 236.;
    }
    else if(t < 1. / 4.) {
        *x = -10. + 2. * cos((80. * t - 18.5) * M_PI);
	*y = 2. * sin((80. * t - 18.5) * M_PI);
    }
    else if(t < 1. / 2.) {
        *x = 40. * t - 20.;
	*y = -52. * t + 11.;
    }
    else if(t < 3. / 4.) {
        *x = 40. * t - 20.;
	*y = 52. * t - 41.;
    }
    else if(t < 7. / 8.) {
        *x = 10. + 2. * cos((-16. * t + 13.5) * M_PI);
	*y = 2. * sin((-16. * t + 13.5) * M_PI);
    }
    else {
        *x = -80. * t + 80.;
	*y = -104. * t + 89.;
    }
}

void g(double t, double *x, double *y)
{
    if(t < .125) {
        *x = 120. * t;
	*y = -15. + 120. * t;
    }
    else if(t < 3. / 20.) {
        *x = 10. + 5. * cos((40. * t - 5.) * M_PI);
	*y = 5. * sin((40. * t - 5.) * M_PI);
    }
    else if(t < 7. / 40.) {
        *x = -80. * t + 17.;
	*y = 0.;
    }
    else if(t < 1. / 5.) {
        *x = 3. * cos((40. * t - 7.) * M_PI);
	*y = 3. * sin((40. * t - 7.) * M_PI);
    }
    else if(t < 9. / 40.) {
        *x = 29. - 160. * t;
	*y = 0.;
    }
    else if(t < 1. / 4.) {
        *x = -10. + 3. * cos((40. * t - 9.) * M_PI);
	*y = 3. * sin((40. * t - 9.) * M_PI);
    }
    else if(t < 1. / 2.) {
        *x = -26. + 52. * t;
	*y = 10. - 40. * t;
    }
    else if(t < 3. / 4.) {
        *x = 28. * t - 14.;
	*y = 40. * t - 30.;
    }
    else if(t < 7. / 8.) {
        *x = 10. + 3. * cos((- 8. * t + 7.) * M_PI);
	*y = 3. * sin((- 8. * t + 7.) * M_PI);
    }
    else {
        *x = -104. * t + 104.;
	*y = -120. * t + 105.;
    }
}

void homotope(double s, double t, double *x, double *y)
{
    double x1, y1, x2, y2;

    if(s < .5) {
        f(t, &x1, &y1);
	g(t, &x2, &y2);
	*x = (1. - 2. * s) * x1 + 2. * s * x2;
	*y = (1. - 2. * s) * y1 + 2. * s * y2;
    }
    else {
        g(t, &x1, &y1);
	h(t, &x2, &y2);
	*x = (2. - 2. * s) * x1 + (2. * s - 1.) * x2;
	*y = (2. - 2. * s) * y1 + (2. * s - 1.) * y2;
    }
}

main()
{
    int adp = 1, i, j;
    double x, y, x0, y0, s, t, ds = .005, dt = .001;

    printf("color 0 0 3\ndisk 0 -15 .3\ntext 1 -15.5 base point\ncolor 0 0 0\ndisk 10 0 .5\ndisk 0 0 .5\ndisk -10 0 .5\ntext 10 2.5 a\ncolor 3 0 0\n");
    for(x0 = 0, y0 = -15., t = 0.; t < 1.; t+= .003) {
        if(t < .25) {
	    x = 40. * t ;
	    y = 52. * t - 15;
	}
	else if(t < .75) {
	    x = 10. + 2. * cos((4. * t - 1.5) * M_PI);
	    y = 2. * sin((4. * t - 1.5) * M_PI);
	}
	else {
	    x = -40. * t + 40;
	    y = -52. * t + 37;
	}
	printf("active 0\nconnect %f %f %f %f\n", x, y, x0, y0);
	printf("active %d\ncopy 0 %d\ndisk %f %f .25\ntext -13 -14 t=%.2f\n", adp, adp, x, y, t);
	x0 = x; y0 = y;
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    printf("active 0\nclear\ncolor 0 0 3\ndisk 0 -15 .3\ntext 1 -15.5 base point\ncolor 0 0 0\ndisk 10 0 .5\ndisk 0 0 .5\ndisk -10 0 .5\ntext 0 2.5 b\ncolor 3 0 0\n");
    for(x0 = 0, y0 = -15., t = 0.; t < 1.; t+= .003) {
        if(t < .25) {
	    x = 0.;
	    y = 52. * t - 15;
	}
	else if(t < .75) {
	    x = 2. * cos((4. * t - 1.5) * M_PI);
	    y = 2. * sin((4. * t - 1.5) * M_PI);
	}
	else {
	    x = 0.;
	    y = -52. * t + 37;
	}
	printf("active 0\nconnect %f %f %f %f\n", x, y, x0, y0);
	printf("active %d\ncopy 0 %d\ndisk %f %f .25\ntext -13 -14 t=%.2f\n", adp, adp, x, y, t);
	x0 = x; y0 = y;
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    printf("active 0\nclear\ncolor 0 0 3\ndisk 0 -15 .3\ntext 1 -15.5 base point\ncolor 0 0 0\ndisk 10 0 .5\ndisk 0 0 .5\ndisk -10 0 .5\ntext -10 2.5 c\ncolor 3 0 0\n");
    for(x0 = 0, y0 = -15., t = 0.; t < 1.; t+= .003) {
        if(t < .25) {
	    x = -40. * t ;
	    y = 52. * t - 15;
	}
	else if(t < .75) {
	    x = -10. + 2. * cos((4. * t - 1.5) * M_PI);
	    y = 2. * sin((4. * t - 1.5) * M_PI);
	}
	else {
	    x = 40. * t - 40;
	    y = -52. * t + 37;
	}
	printf("active 0\nconnect %f %f %f %f\n", x, y, x0, y0);
	printf("active %d\ncopy 0 %d\ndisk %f %f .25\ntext -13 -14 t=%.2f\n", adp, adp, x, y, t);
	x0 = x; y0 = y;
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    printf("active 0\nclear\ncolor 0 0 3\ndisk 0 -15 .3\ntext 1 -15.5 base point\ncolor 0 0 0\ndisk 10 0 .5\ndisk 0 0 .5\ndisk -10 0 .5\ncolor 3 0 0\n");
    for(x0 = 0, y0 = -15., t = 0.; t < 1.; t+= .003) {
        homotope(0, t, &x, &y);
	printf("active 0\nconnect %f %f %f %f\n", x, y, x0, y0);
	printf("active %d\ncopy 0 %d\ndisk %f %f .25\ntext -13 -14 t=%.2f\n", adp, adp, x, y, t);
	x0 = x; y0 = y;
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    printf("sleep 1\n");
    printf("active 0\nclear\ncolor 0 0 3\ndisk 0 -15 .3\ntext 1 -15.5 base point\ncolor 0 0 0\ndisk 10 0 .5\ndisk 0 0 .5\ndisk -10 0 .5\ntext -15 15 This path is homotope to abca\ntext -3.2 15.4 -1\ncolor 3 0 0\n");
    for(s = 0.; s < .97; s += ds) {
      	printf("active %d\ncopy 0 %d\n", adp, adp);
	printf("color 0 0 0\ntext -13 -15 s=%.2f\ncolor 3 0 0\n", s);
	for(x0 = 0, y0 = -15., t = 0.; t <= 1.; t+= dt) {
  	    homotope(s, t, &x, &y);
	    printf("connect %f %f %f %f\n", x, y, x0, y0);
	    x0 = x; y0 = y;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
