#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "complexn2.h"

main(int argc, char *argv[])
{
    CPX z, w, u, v, t;
    int ad = 1;
    double dd = .01;

    if(argc > 1) dd = atof(argv[1]);
    printf("color 0 0 0\nline 1 0 0\nline 0 1 0\n");
    printf("color 0 0 3\ncurve 2 1. 0. 4. -6. 16. 24.75\ntext -3.5 -2.6 x^2 + 4y^2 = 4\n");
    printf("color 0 3 0\ncurve 2 4. 0. 1. -24. 4. 39.75\ntext -3.5 -2.4 4x^2 + y^2 = 4\n");
    printf("color 3 0 0\ncurve 2 7. -10. 7. -62. 58. 149.\ntext -3.5 -2.2 7x^2 - 10xy + 7y^2 = 32\n");
    printf("color 2 2 0\ntext -3.5 -2. 117x^2 - 32y^2 -156.5xy = 228\n");
    for(z.r = -3.4; z.r < 3.4; z.r += dd) {
	if(z.r > -.2 && z.r < .2) z.i = .5 * sqrt(.04 - z.r * z.r);
	else if(z.r > -.95 && z.r < -.85) z.i = .5 * sqrt(.0025 - (.9 + z.r) * (.9 + z.r));
	else if(z.r > .85 && z.r < .95) z.i = .5 * sqrt(.0025 - (z.r - .9) * (z.r - .9));
	else if(z.r > -2.2 && z.r < -2.1) z.i = 1. * sqrt(.0025 - (z.r + 2.15) * (z.r + 2.15));
	else if(z.r > 2.1 && z.r < 2.2) z.i = 1. * sqrt(.0025 - (z.r - 2.15) * (z.r - 2.15));
	else if(z.r > -.6 && z.r < -.2) z.i = 1. * sqrt(.04 - (.4 + z.r) * (.4 + z.r));
	else if(z.r > .2 && z.r < .6) z.i = 1. * sqrt(.04 - (z.r - .4) * (z.r - .4));
	else if(z.r > -2. && z.r < -1.6) z.i = 1. * sqrt(.04 - (z.r + 1.8) * (z.r + 1.8));
	else if(z.r > 1.6 && z.r < 2.) z.i = 1. * sqrt(.04 - (z.r - 1.8) * (z.r - 1.8));
	else z.i = 0.;
	printf("copy 0 %d\nactive %d\n", ad, ad);
	printf("color 0 0 0\nconnect 2. %f 4. %f\n", .25 * z.r - 2., .25 * z.r - 2.);
	printf("color 1 0 1\ntext -3.5 2.5 y = %1.2f + i%1.2f\n", z.r, z.i);
	v = z * z;
	u.r = 4. - 4. * v.r; u.i = -4. * v.i;
	w = rtofcpx(u);
	printf("color 0 0 3\ndisk %f %f .04\n", w.r, w.i);
	printf("disk %f %f .04\n", -w.r, -w.i);
	u.r = 1. - v.r / 4.; u.i = -v.i / 4.;
	w = rtofcpx(u);
	printf("color 0 3 0\ndisk %f %f .04\n", w.r, w.i);
	printf("disk %f %f .04\n", -w.r, -w.i);
	v = z * z;
	u = -24. * v; u.r += 224.;
	t = rtofcpx(u);
	w = 5. * z + t; w.r /= 7.; w.i /= 7.;
	printf("color 3 0 0\ndisk %f %f .04\n", w.r, w.i);
	w = 5. * z - t; w.r /= 7.; w.i /= 7.;
	printf("disk %f %f .04\n", w.r, w.i);
	u = 3744. * v; u.r -= 2176;
	w = t = rtofcpx(u);
	w.r += 156.525; w.r /= 117.; w.i /= 117.;
	printf("color 1 1 0\ndisk %f %f .04\n", w.r, w.i);
	w = -1. * t;
	w.r += 156.525; w.r /= 117.; w.i /= 117.;
	printf("disk %f %f .04\n", w.r, w.i);
	printf("display %d\n", ad);
	if(ad == 1) ad = 2;
	else ad = 1;
    }
    return 0;
}
