#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double ra(double t)
{
/*    if(t < .25) return 1. - 2. * t;
    else if(t < .5) return .5;
    else if(t < .75) return 4. * t - 1.5;
    else return 3. - 2. * t;
*/
    double t2, t3;
    t2 = t * t; t3 = t2 * t;
    return 12. * t3 - 18. * t2 + 6. * t + 1.;
}

double th(double t)
{
/*    if(t < .75) return 4. * M_PI * t;
    else return (-4. * t + 6.) * M_PI;
*/
/*
    return (-8. * t + 10.) * t * M_PI;
*/
    double t2, t3;
    t2 = t * t; t3 = t2 * t;
/*    return 2 * M_PI * (9. * t3 - 12. * t2 + 4. * t);
*/
    return 2 * M_PI * (11. * t3 - 12. * t2 + 2. * t);

}

main()
{
    int adp = 2, i, j, n = 20;
    double dt = .005, t, ds = .005, s, x, y, x0, y0, RRa, TTh, RRa0, TTh0, dth = 2 * M_PI / n;

    printf("disk 0 0 2.1\ngray 1.\ndisk 0 0 2\ngray .9\n");
    for(i = 0, t = 0.; i < n; i++, t += dth) {
	x0 = cos(t); y0 = sin(t);
	printf("connect %f %f %f %f\n", 2. * x0, 2. * y0, .4 * x0, .4 * y0);
    }
    for(i = -n, t = -n * dth; i <= n; i++, t += dth) {
	printf("connect 2.3 %f 4.1 %f\n", .3 * t, .3 * t);
    }
    printf("gray .6\nconnect 2. 0. .4 0.\nconnect 2.3 0. 4.1 0.\nline 1 0 -3\ncircle 0 0 1\n");
    printf("color 0 0 0\ndisk 1 0 .02\ndisk 3 0 .03\nline 1 0 -2.4\nline 1 0 -4.\ndisk 0 0 .4\ncircle 0 0 2\ncolor 0 0 3\n");
    printf("copy 0 1\nactive 1\ndisplay 1\n");
    for(x0 = 1., y0 = t = 0., RRa0 = 1., TTh0 = 0., j = 0; j <= 200; j++, t += dt) {
	if(j == 50) printf("color 0 3 0\n");
	else if(j == 100) printf("color 3 0 0\n");
	else if(j == 150) printf("color 2 2 0\n");
	RRa = ra(t);
	TTh = th(t);
	x = RRa * cos(TTh); y = RRa * sin(TTh);
	printf("connect %f %f %f %f\n", x, y, x0, y0);
	printf("connect %f %f %f %f\n", 2 + RRa, .3 * TTh, 2 + RRa0, .3 * TTh0);
	x0 = x; y0 = y;
	RRa0 = RRa; TTh0 = TTh;
    }
    printf("gray 0.\ntext 4.1 .03 r\ntext 3.9 -.15 2\ntext 2.2 -.15 .5\ntext 3.05 -.15 1\ntext 3. 2.2 theta\ntext 1.1 2.2 x = r cos theta\ntext 1.1 2. y = r sin theta\npause\n");
    for(s = 0., i = 0; i <= 200; i++, s += ds) {
	printf("active %d\ncopy 0 %d\n", adp, adp);
/*
	printf("color 2 2 2\nconnect 2.3 0. 4.1 0.\nline 1 0 -3\nline 1 0 -2.4\nline 1 0 -4.\ndisk 0 0 .4\ncircle 0 0 2\n");
*/
	printf("color 0 0 0\ntext 1. 1.9 s = %2.4f\ncolor 0 0 3\n", s);
	for(x0 = 1., y0 = t = 0., RRa0 = 1., TTh0 = 0., j = 0; j <= 200; j++, t += dt) {
	    if(j == 50) printf("color 0 3 0\n");
	    else if(j == 100) printf("color 3 0 0\n");
	    else if(j == 150) printf("color 2 2 0\n");
	    RRa = (1. - s) * ra(t) + s;
	    TTh = (1. - s) * th(t) + s * t * th(1.);
	    x = RRa * cos(TTh); y = RRa * sin(TTh);
	    printf("connect %f %f %f %f\n", x, y, x0, y0);
	    printf("connect %f %f %f %f\n", 2 + RRa, .3 * TTh, 2 + RRa0, .3 * TTh0);
	    x0 = x; y0 = y;
	    RRa0 = RRa; TTh0 = TTh;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
