#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double ra(double t)
{
/*    if(t < .25) return 1. - 2. * t;
    else if(t < .5) return .5;
    else if(t < .75) return 4. * t - 1.5;
    else return 3. - 2. * t;
*/
    double t2, t3;
    t2 = t * t; t3 = t2 * t;
    return 12. * t3 - 18. * t2 + 6. * t + 1.;
}

double th(double t)
{
/*    if(t < .75) return 4. * M_PI * t;
    else return (-4. * t + 6.) * M_PI;
*/
/*
    return (-8. * t + 10.) * t * M_PI;
*/
    double t2, t3;
    t2 = t * t; t3 = t2 * t;
/*    return 2 * M_PI * (9. * t3 - 12. * t2 + 4. * t);
*/
    return 2 * M_PI * (11. * t3 - 12. * t2 + 2. * t);

}

main()
{
    int adp = 1, i, j;
    double dt = .005, t, ds = .005, s, x, y, x0, y0, RRa, TTh;

    printf("disk 0 0 .4\ncircle 0 0 2\ncolor 0 0 3\n");
    for(x0 = 1., y0 = t = 0., j = 0; j <= 200; j++, t += dt) {
	if(j == 50) printf("color 0 3 0\n");
	else if(j == 100) printf("color 3 0 0\n");
	else if(j == 150) printf("color 2 2 0\n");
	RRa = ra(t);
	TTh = th(t);
	x = RRa * cos(TTh); y = RRa * sin(TTh);
	printf("connect %f %f %f %f\n", x, y, x0, y0);
	x0 = x; y0 = y;
    }
    printf("pause\n");
    for(s = 0., i = 0; i <= 200; i++, s += ds) {
	printf("active %d\nclear\n", adp);
	printf("color 0 0 0\ntext 1.9 1.9 s = %f\ndisk 0 0 .4\ncircle 0 0 2\ncolor 0 0 3\n", s);
	for(x0 = 1., y0 = t = 0., j = 0; j <= 200; j++, t += dt) {
	    if(j == 50) printf("color 0 3 0\n");
	    else if(j == 100) printf("color 3 0 0\n");
	    else if(j == 150) printf("color 2 2 0\n");
	    RRa = ra(t);
	    TTh = th(t);
	    x = (1. - s) * RRa * cos(TTh) + s * cos(t * th(1.));
	    y = (1. - s) * RRa * sin(TTh) + s * sin(t * th(1.));
	    printf("connect %f %f %f %f\n", x, y, x0, y0);
	    x0 = x; y0 = y;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
