#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double x0(double t)
{
/*    double t2 = t * t;
    return 3. * t2 - 1. * t;
*/
    return 2 * t;
}

double y0(double t)
{
    double t2 = t * t;
    return -7. * t2 + 10. * t;
/*
    return 5. * t2 - 2. * t;
    return 3 * t;
*/
}

double x1(double t)
{
    if(t < .5) return 4 * t;
    else return 2.;
}

double y1(double t)
{
    if(t < .5) return 0.;
    else return 6 * t - 3.;
}

main()
{
    int adp = 1, i, j;
    double dt = .005, t, ds = .0025, s, xx, yy, xx0, yy0, u, u0, v, v0;

    printf("text 3.94 -.25 a\ntext 2.8 .9 b\ntext 5.1 2.9 2a+3b\ncolor 0 3 3\npolygon -6 -4 -6 4 2 4 2 -4\n");
    for(xx = 1; xx < 3; xx += .003) {
        yy = sqrt(1. - (2 - xx) * (2 - xx));
	printf("gray %f\ncircle -2 0 %f\n", yy, xx);
    }
    printf("gray .85\n");
    for(i = 0; i < 4; i++) printf("polygon 3 %f 5 %f 5 %f 3 %f\n", i + .5, i + .5, i + 1., i + 1.);
    printf("color 0 0 0\n");
    u0 = 0.; v0 = 0.;
    for(i = 3; i < 6; i++) printf("connect %d 0 %d 4\n", i, i);
    for(i = 0; i < 5; i++) printf("connect 3 %d 5 %d\n", i, i);
    printf("color 0 3 0\ndisk 1 0 .08\ndisk 3 0 .08\ncolor 0 0 3\n");
    printf("copy 0 1\nactive 1\ndisplay 1\n");
    for(xx0 = 3., yy0 = u0 = v0 = u = 0., j = 0; j < 200; j++, u += dt) {
	v = .2 * sin(M_PI * u);
	printf("color 0 0 3\nconnect %f %f %f %f\n", u0 + 3., v0, u + 3., v);
	u0 = u; v0 = v;
	xx = cos(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	yy = sin(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	if(sin(2. * M_PI * v) < 0) printf("color 2 2 3\n");
	else printf("color 0 0 3\n");
	printf("connect %f %f %f %f\n", xx - 2., yy, xx0 - 2., yy0);
	xx0 = xx; yy0 = yy;
    }
    for(xx0 = 3., yy0 = u0 = v0 = v = 0., j = 0; j < 200; j++, v += dt) {
	u = .01 * sin(2 * M_PI * v);
	printf("color 0 3 0\nconnect %f %f %f %f\n", u0 + 3., v0, u + 3., v);
	u0 = u; v0 = v;
	xx = cos(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	yy = sin(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	if(sin(2. * M_PI * v) < 0) printf("color 2 3 2\n");
	else printf("color 0 3 0\n");
	printf("connect %f %f %f %f\n", xx - 2., yy, xx0 - 2., yy0);
	xx0 = xx; yy0 = yy;
    }
    printf("pause\nactive 0\ndisplay 0\ncolor 0 0 3\n");
    for(u0 = v0 = t = 0., j = 0; j < 200; j++, t += dt) {
	u = x1(t); v = y1(t);
	printf("connect %f %f %f %f\n", u0 + 3., v0, u + 3., v);
	u0 = u; v0 = v;
    }
    printf("color 3 0 0\nText 0 20 This path is homotope to 2a+3b\n");
    printf("copy 0 %d\nactive %d\ndisplay %d\ncolor 3 0 0\n", adp, adp, adp);
    u0 = 0.; v0 = 0.;
    for(xx0 = 3., yy0 = t = 0., j = 0; j < 200; j++, t += dt) {
	u = x0(t); v = y0(t);
	printf("color 3 0 0\nconnect %f %f %f %f\n", u0 + 3., v0, u + 3., v);
	u0 = u; v0 = v;
	xx = cos(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	yy = sin(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	if(sin(2. * M_PI * v) < 0) printf("color 3 2 2\n");
	else printf("color 3 0 0\n");
	printf("connect %f %f %f %f\n", xx - 2., yy, xx0 - 2., yy0);
	xx0 = xx; yy0 = yy;
    }
    printf("display %d\npause\n", adp);
    for(adp = 2, s = 0, i = 0; i < 395; i++, s += ds) {
	printf("active %d\ncopy 0 %d\n", adp, adp);
	u0 = 0.; v0 = 0.;
	for(xx0 = 3., yy0 = t = 0., j = 0; j < 200; j++, t += dt) {
	    u = (1. - s) * x0(t) + s * x1(t); v = (1. - s) * y0(t) + s * y1(t);
	    printf("color 3 0 0\nconnect %f %f %f %f\n", u0 + 3., v0, u + 3., v);
	    u0 = u; v0 = v;
	    xx = cos(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	    yy = sin(2. * M_PI * u) * (2 + cos(2. * M_PI * v));
	    if(sin(2. * M_PI * v) < 0) printf("color 3 2 2\n");
	    else printf("color 3 0 0\n");
	    printf("connect %f %f %f %f\n", xx - 2., yy, xx0 - 2., yy0);
	    xx0 = xx; yy0 = yy;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
