#include <stdio.h>
#include <stdlib.h>

#define smax 50000
#define nmax 50000
#define max 20
#define MDIM 5

int z[nmax * MDIM], un, DIM;
void intadjm(int *a, int *b, int n);
char s[255];

main(argc,argv)
	int argc;
	char *argv[];
{
	int i, j, u[MDIM], v[MDIM * MDIM], ct[MDIM], t[MDIM * MDIM];
	void fdwtex();

	if(argc > 1) {
	        DIM = atoi(argv[1]);
		if(DIM < 3 || DIM > MDIM) exit(0);
	}
	else DIM = 3;
	for(i = 0; i < DIM; i++) ct[i] = u[i] = 1;
	for(i = 0; i < DIM; i++) {
	        for(j = 0; j < DIM; j++) {
		        if(i == j) v[i * DIM + j] = 1;
			else v[i * DIM + j] = 0;
		}
	}
	un=0;
	for(i = 0; i < DIM; i++) t[i] = ct[i];
	sprintf(s, "%d $B<!85(B\n", DIM);
	write(1, s, len(s));
	fdwtex(u,v,ct,t,1,1);
	return 0;
}

int ch0(int u[])
{
    int i, s, m, k, a, b;

    for(i = s = 0; i < DIM; i++) s += u[i];
    for(i = m = 0; i < DIM; i++) {
	if((s % u[i]) == 0) m++;
	else k = i;
    }
    if(m == DIM) return 1;
    if(m == DIM - 1 && k < DIM - 1) {
	a = s / u[k];
	s -= a * u[k];
	for(k++; k < DIM - 1; k++) {
	    b = s / u[k];
	    if(b >= a) return 0;
	    s -= b * u[k];
	}
	if((s % u[DIM - 1]) == 0 && a > (s / u[DIM - 1])) return 1;
    }
    return 0;
}

int chint(u,v)
	int u[],v[];
{
	int i,j,sum;

	for(i=0;i<DIM;i++){
		sum=0;
		for(j=0;j<DIM;j++)
			sum+=u[j]*v[i * DIM + j];
		if(sum<=0)
			return 0;
	}
	return 1;
}

void fdlalow(t,u,v,ct,l,q)
	int t[],u[],v[],ct[],l,q;
{
	int i,j,k,d,a[MDIM + 1],t2[MDIM * MDIM],s[MDIM + 1],y[MDIM + 1],x[MDIM],inpr(),inc();
	void fdwtex();

	s[0]=inpr(ct,u,DIM);
	for(i=0;i<DIM;i++){
		if((s[i+1]=inpr(&v[i * DIM],u,DIM))<=0){
			return ;
		}
	}
	for(i = 1; i <= DIM; i++) a[i] = 0;
	for( ;(d=inc(a,s,q))>0;){
		for(i=0;i<DIM;i++){
		        for(j = y[i] = 0; j < DIM; j++) y[i] += v[j * DIM + i] * a[j + 1];
			if((y[i] % q) != 0)
				break;
		}
		if(i==DIM){
			for(j=0;j<DIM;j++) x[j]=(y[j]/q);
/*			printf("l=%d,%d %d %d %d\n",l,x[0],x[1],x[2],x[3]); */
			for(j=0;j<DIM;j++) t[l * DIM + j]=x[j];
			if(l == (DIM - 1)){
				for(j=0;j<DIM;j++) for(k=0;k<DIM;k++) t2[j * DIM + k]=t[j * DIM + k];
				if(thpDIM(t2,u)>0&&chint(u,v)>0) fdwtex(u,v,ct,t,DIM,q);
			}
			else{
				for(j=0;j<l+1;j++) for(k=0;k<DIM;k++) t2[j * DIM + k]=t[j * DIM + k];
				if(ratpt(t2,l+1,v,DIM,DIM,u)>0) fdwtex(u,v,ct,t,l+1,q);
			}
		}
	}
}

int inc(a,s,q)
	int a[],s[],q;
{
	int i;

	for(a[DIM]++, i = DIM - 1; inpr(a + 1, s + 1, DIM) >= q * s[0]; i--){
		if(i==0)
			return 0;
		a[i]++;			
		a[i+1]=0;
	}
	return 1;
}

int fdlaon(x,u,v,ct,q)
	int x[],u[],v[],ct[],q;
{
	int i,j,d,n=0,a[MDIM + 1],s[MDIM + 1],y[MDIM + 1],inpr(),incon();

	s[0]=inpr(ct,u,DIM);
	for(i=0;i<DIM;i++){
		if((s[i+1]=inpr(&v[i * DIM],u,DIM))<=0){
			return -1;
		}
	}
	for(j = 1; j <= DIM; j++) a[j] = 0;
	for( ;(d=incon(a,s,q))>0;){
		if(d==2){
			for(i=0;i<DIM;i++){
			        for(j = y[i] = 0; j < DIM; j++) y[i] += v[j * DIM + i] * a[j + 1];
				if((y[i] %q) != 0)
					break;
			}
			if(i == DIM){
				for(j=0;j<DIM;j++) x[n * DIM + j]=(y[j]/q);
				n++;
			}
			if(n>=smax){
				printf("Over(on)\n");
				exit(0);
			}
		}
	}
	return n;
}

int incon(a,s,q)
	int a[],s[],q;
{
	int i,d;

	for(a[DIM]++,i = DIM - 1;
		(d=inpr(a + 1, s + 1, DIM) - q * s[0])>0;i--){
		if(i==0)
			return 0;
		a[i]++;
		a[i+1]=0;
	}
	if(d==0)
		return 2;
	else
		return 1;
}

void fdwtex(u,v,ct,t,l,q)
	int u[],v[],ct[],t[],l,q;
{
	extern int z[nmax * MDIM],un;
	void fdwtex();
	int i, f, d, x[smax * MDIM], chctn(),alex(),gcd(),ratpt();
	void fdlalow();

/*	printf("fdwtex is called l=%d\n",l); */
	d=fdlaon(x,u,v,ct,q);
/*	printf("d=%d\n",d); 
	for(i=0;i<d;i++) printf("(%d,%d,%d,%d)\n",x[i * DIM],x[i * DIM + 1],x[i * DIM + 2],x[i * DIM + 3]); */
	if(d>0) {
	        for(i = 1; i < DIM; i++) if(u[i - 1] < u[i]) break;
		if(i == DIM && alex(u) > 0 && (ch0(u) > 0 || chctn(x,d,ct,DIM) > 0)){
			int wsum,wg;
			sprintf(s, "%d=> ",un+1);
			write(1, s, len(s));
			for(wsum=i=0;i<DIM;i++){
				z[un * DIM + i]=u[i];
				wsum+=u[i];
				sprintf(s, "%d ",u[i]);
				write(1, s, len(s));
			}
			sprintf(s, " => ");
			write(1, s, len(s));
			for(i=0;i<DIM;i++){
				wg=gcd(u[i],wsum);
				sprintf(s, "%d/%d ",u[i]/wg,wsum/wg);
				write(1, s, len(s));
			}
			un++;
			sprintf(s, "\n");
			write(1, s, 1);
			if(un>=nmax){
				printf("un>nmax");
				exit(0);
			}
/*		        for(i=0;i<d;i++){
				printf("(%d,%d,%d,%d) ",x[i * DIM],x[i * DIM + 1],x[i * DIM + 2],x[i * DIM + 3]);
				if((i%5)==4) printf("\n");
			}
			printf("\n"); */
		}
		/* else printf("ct is not in the interior\n"); */
	}
	if(l<DIM){
		fdlalow(t,u,v,ct,l,q);
	}
}

int alex(u)
	int u[];
{
	int i,j;
	extern int z[],un;

	for(i=0;i<un;i++){
		for(j=0;j<DIM;j++){
			if(u[j]!=z[i * DIM + j])
				break;
		}
		if(j==DIM)
			return 0;
	}
	return 1;
}

int thpDIM(a,x)
	int a[],x[];
{
	int i,d,b[MDIM],hyplth(),redu();

	for(i=0;i<DIM;i++) b[i]=1;
	d=hyplth(a,b,x,DIM);
	redu(x,DIM);
	return d;
}

/*
void disp(a,x)
	int a[],x[];
{
	int i;

	for(i=0;i<DIM;i++){
		int j;
		for(j=0;j<DIM;j++) printf("%d ",a[i * DIM + j]);
		printf("%d\n",x[i]);
	}
	printf("\n");
}
*/

int thp(a,x)
	int a[],x[];
{
	int b[MDIM - 1],i,d;

	for(i=0;i < DIM - 1;i++) b[i]=1;
	x[DIM]=hyplth(a,b,x,DIM - 1);
	/* redu(x,DIM); */
	return x[DIM];
}

int redu(x,n)
	int x[],n;
{
	int i,g,gcd();

	g=gcd(x[0],x[1]);
	for(i=2;i<n;i++) g=gcd(g,x[i]);
	for(i=0;i<n;i++) x[i]/=g;
	return g;
}

int next(a,l,n)
	int a[],l,n;
{
	int i;

	if(l<1) return 0;
	if(a[l-1]<n){
		a[l-1]++;
		return 1;
	}
	for(i=l-2;i>-1;i--) {
		if(a[i]<a[i+1]-1) {
			int j;
			a[i]++;
			for(j=i+1;j<l;j++)
				a[j]=a[j-1]+1;
			return 1;
		}
	}
	return 0;
}

int gcd(a,b)
	int a,b;
{
	int c;

	if(b<0)
		b= -b;
	if(a==0)
		return b;
	if(a<0)
		a= -a;
	for(;;){
		if((c=(b%a))==0)
			return a;
		else {
			b=a;
			a=c;
		}
	}
}

int ratpt(u,l,v,m,d,e)
	int u[],l,v[],m,d,e[];
{
	int a[max],b[max*max],bi[max*max],x[max * max * max],w[max],i,j,f,g,n=0;
	void intadjm();

	for(i=0;i<d-l;i++) a[i]=i;
	for(i=0;i<l;i++) w[i]=1;
	for(i=l;i<d;i++) w[i]=0;
	do{
		/* for(i=0;i<d-l;i++) printf("%d ",a[i]);
			 printf("\n"); */
		for(i=0;i<l;i++){
			for(j=0;j<d;j++) b[i*d+j]=u[i*d+j];
		}
		for(i=l;i<d;i++){
			for(j=0;j<d;j++) b[i*d+j]=v[a[i-l]*d+j];
		}
		/* disp(d,b); */
		if((i=intdet(b,d))!=0){
			/* printf("det=%d\n",i); */
			if(i>0) f=1;
			else f= -1;
			intadjm(b,bi,d);
			/* disp(d,bi); */
			for(i=0;i<d;i++) {
				x[n * DIM + i]=0;
				for(j=0;j<d;j++) x[n * DIM + i]+=f*bi[i*d+j]*w[j];
			}
			for(i=0;i<m;i++) if(inpr(&x[n * DIM],&v[i*d],d)<0) break;
			if(i==m) n++;
			/* for(i=0;i<d;i++) printf("%d,",x[(n - 1) * DIM + i]);
				 printf("\n"); */
		}
	}while(next(a,d-l,m-1)>0);
	if(n==0) return(0);
	for(i=0;i<d;i++){
		e[i]=0;
		for(j=0;j<n;j++) e[i]+=x[j * DIM + i];
	}
	g=e[0];
	for(i=1;i<d;i++) g=gcd(g,e[i]);
	if(g>0) for(i=0;i<d;i++) e[i]/=g;
	for(i=0;i<m;i++) if(inpr(&v[i*d],e,d)<=0) return 0;
	return 1;
}
/*
int disp(d,a)
	int d,a[];
{
	int i,j;
	for(i=0;i<d;i++){
		for(j=0;j<d;j++) printf("%d ",a[i*d+j]);
		printf("\n");
	}
}
*/

int inpr(x,y,n)
	int x[],y[],n;
{
	int i,p=0;

	for(i=0;i<n;i++) p+=x[i]*y[i];
	return p;
}

int hyplth(a,b,x,n)
	int a[],b[],x[],n;
{
	int a1[max*max],i,j,d,g;
	void intadjm();

	d=intdet(a,n);
	if(d==0) return(0);
	intadjm(a,a1,n);
	for(i=0;i<n;i++){
		for(x[i]=j=0;j<n;j++) x[i]+=(a1[i*n+j]*b[j]);
	}
	if(d<0) {
		for(i=0;i<n;i++) x[i]*=(-1);
		d*=(-1);
	}
/*	for(g=gcd(x[0],x[1]),i=2;i<n;i++) g=gcd(g,x[i]);
	for(i=0;i<n;i++) x[i]/=g; */
	return d; 
}
int chalex(v,n,x)
	int v[],n,x[];
{
	int i,j;
	for(i=0;i<n;i++){
		for(j=0;j<DIM;j++) if(x[j]!=v[i * DIM + j]) break;
		if(j==DIM) return 1;
	}
	return -1;
}
	
chctn(u,l,ct,n)
	int u[],l,ct[],n;
{
	int m[max],i,j,a[max*max],b[max],v[max],d=0;

	for(i=0;i<n;i++){
		for(a[n*(n-1)+i]=j=0;j<l;j++) a[n*(n-1)+i]+=u[j*n+i];
		m[i]=i;
		b[i]=0;
	}
	b[n-1]=1;
	do{
		for(i=0;i<n-1;i++) for(j=0;j<n;j++) a[i*n+j]=u[m[i]*n+j];
		if(hyplth(a,b,v,n)>0){
			int f=0,g;
			for(i=0;i<l;i++) if((g=inpr(u+(i*n),v,n))<0) break;
			if(i==l){
				if(inpr(ct,v,n)>0) {
					d++;
				}
				else return -1;
			}
		}
	}while(next(m,n-1,l-1)>0);
	return d;
}

int intdet(a,n)
	int a[],n;
{
	int i,s,l[max],d=0;
	
	for(i=0;i<n;i++) l[i]=i;
	do{
		s=sgn(l,n);
		for(i=0;i<n;i++) s*=a[i*n+l[i]];
		d+=s;
	}while(factorial(n,l)>0);
	return d;
}

void intadjm(a,b,n)
	int a[],b[],n;
{
	int i,i2,j,j2,d,s,l[max],k;

	for(i=0;i<n;i++){
		for(j=0;j<n;j++){
			d = 0;
			for(k=0;k<n-1;k++) l[k]=k;
			do {
				s=sgn(l,n-1);
				for(k=0;k<n-1;k++) {
					j2=l[i2=k];
					if(i2>=i) i2++;
					if(j2>=j) j2++;
					s *= a[i2*n+j2];
				}
				d += s;
			}while(factorial(n-1,l)>0);
			if(((i+j)%2)!=0) d *= -1;
			b[j*n+i] = d;
		}
	}
}
int factorial(n,a)
    register int n,a[];
{
    register int i,j;

    for(i=n-2;i>=0;i--){
        if(a[i]>a[i+1]) continue;
        for(j=i+2;j<n;j++) if(a[j]<a[i]) break;
        swap(a+i,a+j-1);
        for(i++,n--;i<n;) swap(a+(i++),a+(n--));
        return 1;
    }
    return 0;
}

int swap(a,b)
    int *a,*b;
{
    int t;

    t= *a;
    *a= *b;
    *b= t;
}
int sgn(a,n)
	int a[],n;
{
	int i,j,f=0;

	for(i=0;i<n-1;i++)
		for(j=i+1;j<n;j++) if(a[i]>a[j]) f++;
	if((f%2)==0) return 1;
	else return -1;
}

int len(s)
	char *s;
{
	int i=0;

	while(*(s++)!='\0') i++;
	return i;
}
