#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double gaishin(double x1, double y1, double x2, double y2, double x3, double y3, double *x0, double *y0)
{
    double d, rad, x, y, a11, a12, a21, a22, b1, b2;

    a11 = x1 - x2;
    a12 = y1 - y2;
    b1 = (y1 * y1 - y2 * y2 + x1 * x1 - x2 * x2) / 2.;
    a21 = x1 - x3;
    a22 = y1 - y3;
    b2 = (y1 * y1 - y3 * y3 + x1 * x1 - x3 * x3) / 2.;
    if((d = a11 * a22 - a12 * a21) == 0.) return 0.;
    *x0 = (b1 * a22 - b2 * a12) / d;
    *y0 = (a11 * b2 - a21 * b1) / d;
    x = x1 - *x0;
    y = y1 - *y0;
    return sqrt(x * x + y * y);
}

main(int argc, char *argv[])
{
    double x1, y1, x2, y2, x3, y3, x0, y0, rad;

    if(argc < 7) exit(0);
    x1 = atof(argv[1]);
    y1 = atof(argv[2]);
    x2 = atof(argv[3]);
    y2 = atof(argv[4]);
    x3 = atof(argv[5]);
    y3 = atof(argv[6]);
    printf("(%f, %f)\n", x1, y1);
    printf("(%f, %f)\n", x2, y2);
    printf("(%f, %f)\n", x3, y3);
    if((rad = gaishin(x1, y1, x2, y2, x3, y3, &x0, &y0)) == 0.) {
        printf("ϰľˤ롣\n");
    }
    else {
        printf("γ (%f, %f) Ⱦ¤ %f\n", x0, y0, rad);
    }
    return 0;
}
