#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXD 5

double c[(MAXD + 1) * (MAXD + 2) / 2];

int getpoly_2v(int md, double c[], char *s)
{
    int x, y, d, dd = 0, top = (md + 1) * (md + 2) / 2 - 1;
    char *s0, cs;
    double f = 1., w = 0;

    x = y = 0;
    for(; *s != 0; s++) {
	switch(*s) {
	  case 'x': s++; if(*s == '^') s++;
	            if(*s <= '9' && *s > '0') x = *s - '0'; 
	            else {x = 1; s--;}
	    break;
	  case 'y': s++; if(*s == '^') s++;
	            if(*s <= '9' && *s > '0') y = *s - '0'; 
	            else {y = 1; s--;}
	    break;
	  case '-':
	  case '+':
	  case ' ': if((d = x + y) > md) return 0;
	            if(d > dd) dd = d;
	            c[top - d * (d + 1) / 2 - x] += f * w;
	            w = 0.; x = y = 0;
	            if(*s == '-') f = -1.;
	            else f = 1.;
	    break;
	    break;
	  default: for(s0 = s; ; s++) if((*s > '9' || *s < '0') && *s != '.') break;
	           if((cs = *s) == 0) {
		       w = atof(s0);
		       s--;
		       break;
		   }
	           *s = 0;
	           w = atof(s0);
	           *s = cs;
	           if(cs == 'x' || cs == 'y') s--;
/*	           if(cs != '*') s--;
                   if(*s <= '9' && *s >= '0') {
		       w *= 10.;
	               w += (double)(*s - '0');
		   }
*/
	    break;
	}
    }
    if((d = x + y) > md) return 0;
    if(d > dd) dd = d;
    c[top - d * (d + 1) / 2 - x] += f * w;
    return dd;
}

main(int argc, char *argv[])
{
    int i, d, t = (MAXD + 1) * (MAXD + 2) / 2, t0, df;

    if(argc == 1 || (d = getpoly_2v(MAXD, c, argv[1])) == 0) exit(0);
    t0 = (d + 1) * (d + 2) / 2;
    df = t - t0;
    for(i = 0; i < t0; i++) c[i] = c[i + df];
    for(i = 0; i < t0; i++) printf("%f ", c[i]);
    printf("\n");
    return 0;
}
