#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXD 10

double c[(MAXD + 1) * (MAXD + 2) / 2];

int getpoly_2v(int md, double c[], char *s)
{
    int x, y, d, dd = 0, top = (md + 1) * (md + 2) / 2 - 1;
    char *s0, cs, xoy;
    double f, w = 0;

    for(; *s != 0; ) {
	x = y = 0; f = 1.;
	if(*s == '+') s++;
	if(*s == '-') {
	    f = -1.;
	    s++;
	}
	for(s0 = s; ; s++) if((*s > '9' || *s < '0') && *s != '.') break;
	if(s0 == s) w = 1.;
	else {
	    cs = *s; *s = 0;
	    w = atof(s0);
	    *s = cs;
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if((d = x + y) > md) return 0;
	if(d > dd) dd = d;
	c[top - d * (d + 1) / 2 - x] += f * w;
    }
    return dd;
}

main(int argc, char *argv[])
{
    int i, d, t = (MAXD + 1) * (MAXD + 2) / 2, t0, df;

    if(argc == 1 || (d = getpoly_2v(MAXD, c, argv[1])) == 0) exit(0);
    t0 = (d + 1) * (d + 2) / 2;
    df = t - t0;
    for(i = 0; i < t0; i++) c[i] = c[i + df];
    for(i = 0; i < t0; i++) printf("%f ", c[i]);
    printf("\n");
    return 0;
}
