#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#define NUMOFBUTTON 2
#define END 0
#define EXEC 1
#define TOP_WIDTH 648
#define TOP_HEIGHT 520
#define BUTTON_WIDTH 50
#define BUTTON_HEIGHT 26
#define CANVAS_WIDTH 640
#define CANVAS_HEIGHT 480
#define DRAW_BLACK 1
#define DRAW_WHITE 2
#define MNP 10

Display *display;
char *button_name[] = {"End", "Save"};
Window top;
Window buttons[NUMOFBUTTON];
GC buttonGC;
Font font;
Window canvas;
GC canvasGC;
Pixmap pixmap;
GC pmGC;
GC clearGC;
int commandX, commandY, path;
Colormap cmap;
XColor red, green, blue, yellow, dsg, navyb, dgreen, skyblue, dtur, olive, lslateb, lskyb, orange, cyan, white, gray, rgb;
XPoint points[MNP];
char *grcmds[]={"color","dot","line","ellipse","polygon","polyline","circle","stop",0};
char *savefilename;
int ox, oy;

main(argc, argv)
    int argc;
    char *argv[];
{
    char *server, *ps;
    int i;

    ox = CANVAS_WIDTH/2; oy = CANVAS_HEIGHT/2;
    savefilename = "DATA/bitmap0.dat";
	for(i = 1; i < argc; i++) {
		if(*(ps = argv[i]) != '-') continue;
		ps++;
/*		if(*ps == 'W' | *ps == 'w') {
			if(*(++ps) == '=') ps++;
			if((width = atoi(ps)) > MAXWD) width = MAXWD;
			continue;
		}
		if(*ps == 'H' | *ps == 'h') {
			if(*(++ps) == '=') ps++;
			if((height = atoi(ps)) > MAXHT) height = MAXHT;
			continue;
		}
*/
		if(*ps == 'F' | *ps == 'f') {
			if(*(++ps) == '=') ps++;
			savefilename = ps;
			continue;
		}
		if(*ps == 'X' | *ps == 'x') {
			if(*(++ps) == '=') ps++;
			ox = atoi(ps);
			continue;
		}
		if(*ps == 'Y' | *ps == 'y') {
			if(*(++ps) == '=') ps++;
			oy = atoi(ps);
			continue;
		}
/*		if(*ps == 'C' | *ps == 'c') {
			codr = 1;
		}
*/
	}
    server = NULL;
    if((display = XOpenDisplay(server)) == NULL) exit(0);
/*    if(argc==1) 
*/
    path=0;
/*    else if((path=open(argv[1],O_RDONLY))== -1) exit(0);
*/
    cmap = DefaultColormap(display, DefaultScreen(display));
    XAllocNamedColor(display, cmap, "red", &red, &rgb);
    XAllocNamedColor(display, cmap, "green", &green, &rgb);
    XAllocNamedColor(display, cmap, "blue", &blue, &rgb);
    XAllocNamedColor(display, cmap, "yellow", &yellow, &rgb);
    XAllocNamedColor(display, cmap, "white", &white, &rgb);
    XAllocNamedColor(display, cmap, "DarkSlateGray", &dsg, &rgb);
    XAllocNamedColor(display, cmap, "DarkGreen", &dgreen, &rgb);
    XAllocNamedColor(display, cmap, "NavyBlue", &navyb, &rgb);
    XAllocNamedColor(display, cmap, "SkyBlue", &skyblue, &rgb);
    XAllocNamedColor(display, cmap, "DarkTurquoise", &dtur, &rgb);
    XAllocNamedColor(display, cmap, "OliveDrab", &olive, &rgb);
    XAllocNamedColor(display, cmap, "LightSlateBlue", &lslateb, &rgb);
    XAllocNamedColor(display, cmap, "LightSkyBlue", &lskyb, &rgb);
    XAllocNamedColor(display, cmap, "orange", &orange, &rgb);
    XAllocNamedColor(display, cmap, "cyan", &cyan, &rgb);
    XAllocNamedColor(display, cmap, "gray", &gray, &rgb);
    CreateResource();
    EventLoop();
    DestroyResource();
    XCloseDisplay(display);
    if(path>0) close(path);
}

CreateResource()
{
    int x, i;
    Cursor cursor;

    top = XCreateSimpleWindow(display, DefaultRootWindow(display), 0, 0, TOP_WIDTH, TOP_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    XStoreName(display, top, "Graphic Drawing");
    x = 2;
    cursor = XCreateFontCursor(display, XC_coffee_mug);
    XDefineCursor(display, top, cursor);
    for(i = 0; i < NUMOFBUTTON; i++, x += 60) 
        buttons[i] = XCreateSimpleWindow(display, top, x, 2, BUTTON_WIDTH, BUTTON_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    cursor = XCreateFontCursor(display, XC_hand1);
    for(i = 0; i < NUMOFBUTTON; i++) XDefineCursor(display, buttons[i], cursor);
    canvas = XCreateSimpleWindow(display, top, 2, 34, CANVAS_WIDTH, CANVAS_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));

    XSelectInput(display, top, KeyPressMask);
    for(i = 0; i < NUMOFBUTTON; i++) XSelectInput(display, buttons[i], ExposureMask | ButtonPressMask);
    XSelectInput(display, canvas,  ExposureMask | ButtonPressMask);

    buttonGC = XCreateGC(display, top, 0, 0);
    XSetForeground(display, buttonGC, BlackPixel(display, DefaultScreen(display)));
    canvasGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display)));

    font = XLoadFont(display, "12x24");
    XSetFont(display, buttonGC, font);

    XMapWindow(display, top);
    XMapSubwindows(display, top);

    pixmap = XCreatePixmap(display, canvas, CANVAS_WIDTH, CANVAS_HEIGHT, 
			   DefaultDepth(display, DefaultScreen(display)));
    clearGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, clearGC, WhitePixel(display, DefaultScreen(display)));
    XFillRectangle(display, pixmap, clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    pmGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, pmGC, BlackPixel(display, DefaultScreen(display)));
    XSetBackground(display, pmGC, WhitePixel(display, DefaultScreen(display)));
}

EventLoop()
{
    XEvent event;
    void drawg();

    XNextEvent(display, &event); ReDraw(&event);
    drawg();
/*    Xflush(display);
*/    for(;;) {
        XNextEvent(display, &event);
	switch(event.type)
	{
	case Expose: ReDraw(&event); break;
	case ButtonPress: if(HitButton(&event) == END) return; break;
	case KeyPress : if(HitKey(&event) == END) return; break;
	}
    }
}

ReDraw(event)
    XExposeEvent *event;
{
    int i;

    for(i = 0; i < NUMOFBUTTON; i++) {
        if(event->window == buttons[i]) {
	    XDrawString(display, buttons[i], buttonGC, 1, 23, 
			button_name[i], strlen(button_name[i]));
	    return;
	}
	if(event->window == canvas) {
	    XCopyArea(display, pixmap, canvas, pmGC,
		      event->x, event->y, event->width, event->height, event->x, event->y);
	}
    }
}

HitButton(event)
    XButtonEvent *event;
{
    int button;

    if(event->button == Button1) {
        for(button = 0; button < NUMOFBUTTON; button++) {
	    if(event->window == buttons[button]) {
	        if(button == 0) return END;
	        if(button == 1) save();
		return(EXEC);
	    }
	}
	if(event->window == canvas) {
	    commandX = event->x;
	    commandY = event->y;
	}
    }
    return(EXEC);
}

HitKey(event)
    XKeyEvent *event;
{
    char ch;
    KeySym keysym;

    XLookupString(event, &ch, 1, &keysym, NULL);
    switch(keysym) {
    case XK_s: save(); break;
    case XK_F1:
    case XK_e: return(END); break;
    case XK_b: SelectColor(DRAW_BLACK); break;
    case XK_w: SelectColor(DRAW_WHITE); break;
    }
    return(EXEC);
}

save()
{
    Pixmap bitmap;
    GC bitmapGC;

    bitmap = XCreatePixmap(display, canvas, CANVAS_WIDTH, CANVAS_HEIGHT, 1);
    bitmapGC = XCreateGC(display, bitmap, 0, 0);
    XSetForeground(display, bitmapGC, BlackPixel(display, DefaultScreen(display)));
    XSetBackground(display, bitmapGC, WhitePixel(display, DefaultScreen(display)));
    XCopyPlane(display, pixmap, bitmap, bitmapGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0, 1);
    if(XWriteBitmapFile(display, savefilename, bitmap, CANVAS_WIDTH, CANVAS_HEIGHT, -1, -1) != BitmapSuccess)
      fprintf(stderr, "cannot write\n");
    XFreeGC(display, bitmapGC);
}

SelectColor(color)
    int color;
{
    switch(color) {
        case DRAW_BLACK: XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display))); break;
        case DRAW_WHITE: XSetForeground(display, canvasGC, WhitePixel(display, DefaultScreen(display))); break;
    }
}

DestroyResource()
{
    XUnloadFont(display, font);
    XFreeGC(display, buttonGC);
    XFreeGC(display, canvasGC);
    XFreeGC(display, pmGC);
    XFreeGC(display, clearGC);
    XFreePixmap(display, pixmap);
    XDestroySubwindows(display, top);
    XDestroyWindow(display, top);
}

void drawg()
{
    int x,y,color;
    int x2,y2,pcolor,bcolor;
    extern char *grcmds[];
    int i,d=8,a[30],l;
    char s[255];

    setcolor(color=0);
    for(i = 0; i <= CANVAS_WIDTH; i += 10) {
        XDrawPoint(display, canvas, canvasGC, i, oy);
        XDrawPoint(display, pixmap, canvasGC, i, oy);
    }
    for(i = 0; i <= CANVAS_HEIGHT; i += 10) {
        XDrawPoint(display, canvas, canvasGC, ox, i);
        XDrawPoint(display, pixmap, canvasGC, ox, i);
    }
    while(getl(s)>=2) {
        l=cut(s,a);
        for(i=0;i<d;i++) if(cmpword(s,grcmds[i])==0) break;
        if(i==7) break;
        switch(i) {
            case 0: if(l>1) color=atoi(s+a[1]);
                    setcolor(color);
                    break;
            case 1: if(l>2){
                        x=ox+atoi(s+a[1]);
                        y=oy+atoi(s+a[2]);
                        XDrawPoint(display, canvas, canvasGC, x, y);
                        XDrawPoint(display, pixmap, canvasGC, x, y);
                    }
                    break;
            case 2: if(l>4){
                        x=ox+atoi(s+a[1]);
                        y=oy+atoi(s+a[2]);
                        x2=ox+atoi(s+a[3]);
                        y2=oy+atoi(s+a[4]);
                        XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                        XDrawLine(display, pixmap, canvasGC, x, y, x2, y2);
                    }
                    break;
            case 3: if(l>3) {
                        x=ox+atoi(s+a[1]);y=oy+atoi(s+a[2]);
	                x2=atoi(s+a[3]);
        	        if(l>4)y2=atoi(s+a[4]);
                	else y2=x2;
                          XDrawArc(display, canvas, canvasGC, x - x2, y - y2, 2 * x2, 2 * y2, 0, 64 * 360);
                          XDrawArc(display, pixmap, canvasGC, x - x2, y - y2, 2 * x2, 2 * y2, 0, 64 * 360);
                    }
                    break;
            case 4: if(l > 6){
                        int count,j;
                        count = l/2;
                        if(count>MNP) count=MNP;
                        for(j=0;j<count;j++) {
                            points[j].x = ox + atoi(s+a[2 * j + 1]); points[j].y = oy + atoi(s+a[2 * j + 2]);
			}
			XSetFillRule(display, canvasGC, EvenOddRule);
			XFillPolygon(display, canvas, canvasGC, points, count, Complex, CoordModeOrigin);
			XFillPolygon(display, pixmap, canvasGC, points, count, Complex, CoordModeOrigin);
                    }
                    break;
            case 5: if(l>4) {
                        int count,j;
                        count = l/2;
                        if(count>MNP) count=MNP;
                        x2 = ox + atoi(s+a[1]);y2 = oy + atoi(s+a[2]);
                        for(j=1;j<count;j++) {
                              x = x2; y = y2; x2 = ox + atoi(s+a[2*j+1]); y2 = oy + atoi(s+a[2*j+2]);
                              XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                              XDrawLine(display, pixmap, canvasGC, x, y, x2, y2);
                        }
                    }
                    break;
            case 6: if(l>3) {
                          x = ox + atoi(s+a[1]); y = oy + atoi(s+a[2]);
                          x2=atoi(s+a[3]);
                          XDrawArc(display, canvas, canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, 0, 64 * 360);
                          XDrawArc(display, pixmap, canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, 0, 64 * 360);
                      }
                      break;
            default: break;
        }
    }
}

int setcolor(color)
    int color;
{
    switch(color) {
    case 0: XSetForeground(display, canvasGC, dsg.pixel);
      XSetForeground(display, pmGC, dsg.pixel);
      break;
    case 1: XSetForeground(display, canvasGC, blue.pixel);
      XSetForeground(display, pmGC, blue.pixel);
      break;
    case 2: XSetForeground(display, canvasGC, dgreen.pixel);
      XSetForeground(display, pmGC, green.pixel);
      break;
    case 3: XSetForeground(display, canvasGC, skyblue.pixel);
      XSetForeground(display, pmGC, skyblue.pixel);
      break;
    case 4: XSetForeground(display, canvasGC, red.pixel);
      XSetForeground(display, pmGC, red.pixel);
      break;
    case 5: XSetForeground(display, canvasGC, dtur.pixel);
      XSetForeground(display, pmGC, dtur.pixel);
      break;
    case 6: XSetForeground(display, canvasGC, olive.pixel);
      XSetForeground(display, pmGC, olive.pixel);
      break;
    case 8: XSetForeground(display, canvasGC, gray.pixel);
      XSetForeground(display, pmGC, gray.pixel);
      break;
    case 9: XSetForeground(display, canvasGC, lslateb.pixel);
      XSetForeground(display, pmGC, lslateb.pixel);
      break;
    case 10: XSetForeground(display, canvasGC, green.pixel);
      XSetForeground(display, pmGC, navyb.pixel);
      break;
    case 11: XSetForeground(display, canvasGC, lskyb.pixel);
      XSetForeground(display, pmGC, lskyb.pixel);
      break;
    case 12: XSetForeground(display, canvasGC, orange.pixel);
      XSetForeground(display, pmGC, orange.pixel);
      break;
    case 13: XSetForeground(display, canvasGC, cyan.pixel);
      XSetForeground(display, pmGC, cyan.pixel);
      break;
    case 14: XSetForeground(display, canvasGC, yellow.pixel);
      XSetForeground(display, pmGC, yellow.pixel);
      break;
    case 15: XSetForeground(display, canvasGC, WhitePixel(display, DefaultScreen(display)));
      XSetForeground(display, pmGC, WhitePixel(display, DefaultScreen(display)));
      break;
    case 7:
    default: XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display)));
      XSetForeground(display, pmGC, BlackPixel(display, DefaultScreen(display)));
      break;
    }
}

int cut(s,a)
    char s[];
    int a[];
{
    int i,d=0;

    a[d++]=0;
    for(i=0;;i++){
        if(s[i]==' '||s[i]==','||s[i]=='\n'){
            a[d++]=i+1;
            s[i]='\0';
        }
        else if(s[i]=='\0') break;
    }
    return(d);
}

#define buffer2 255

int getl(s)
    char *s;
{
    static int f=0;
    int l=0;
    if(f==1) return(-1);
    for(;l<buffer2;s++,l++) {
        if(read(path,s,1)>0) {
            if(*s=='\n') {
                *s='\0';
                return(l);
            }
        }
        else {
            if(l==0) return(-1);
                f=1;
                *s='\0';
                return(l);
        }
    }
    return(buffer2);
}

int cmpword(s1,s2)
    char *s1, *s2;
{
    for(;;){
        if(*s1>*s2) return(1);
        else if(*s1<*s2) return(-1);
        if(*(s1++)=='\0') break;
        s2++;
    }
    return(0);
}
