#include <stdio.h>
#include <stdlib.h>

#define MAXN 20

int toir[3][MAXN], height[3];

void ex(int left, int middle, int right, int n);
void move(int a, int b);
void display(void);

main(int argc, char *argv[])
{
    int i, n = 3;

    if(argc > 1) n = atoi(argv[1]);
    if(n >MAXN) return 0;
    height[0] = n; height[1] = height[2] = 0;
    for(i = 0; i < n; i++) toir[0][i] = n - i;
    display();
    ex(0, 1, 2, n);
    return 0;
}

void ex(int left, int middle, int right, int n)
{
    if(n == 0) return;
    ex(left, right, middle, n - 1);
/*    printf(" move from %d to %d\n", left, right); */
    move(left, right);
    display();
    ex(middle, left, right, n - 1);
}

void move(int a, int b)
{
    toir[b][height[b]++] = toir[a][--height[a]];
}

void display(void)
{
     int i, j;

     for(i = 0; i < 3; i++) {
	 printf("%d:", i);
	 for(j = 0 ;j < height[i]; j++) printf("%d ", toir[i][j]);
	 printf("\n");
     }
     printf("\n");
}
