#include <stdio.h>

#define MAXN 100
int l = 1, d[MAXN + 1];

void hanoi3(int n, int t1, int t2, int t3)
{
    if(n == 0) return;
    hanoi3(n - 1, t1, t3, t2);
    printf("%d: %d -> %d\n", l++, t1, t3);
    hanoi3(n - 1, t2, t1, t3);
}

void hanoi4(int n, int t1, int t2, int t3, int t4)
{
    int dd, nn;

    if(n == 0) return;
    dd = d[n]; nn = n - dd;
    hanoi4(nn, t1, t2, t4, t3);
    hanoi3(dd, t1, t2, t4);
    hanoi4(nn, t3, t1, t2, t4);
}

main(int argc, char *argv[])
{
    int i, j, m, n;

    if(argc > 1) {
	if((n = atoi(argv[1])) > MAXN || n < 1) exit(0);
    }
    else n = 5;
    for(i = m = 1; ; i++) {
	for(j = 1; j <= i + 1; j++) {
	    d[m++] = i;
	    if(m > n) break;
	}
	if(j <= i + 1) break;
    }
    hanoi4(n, 1, 2, 3, 4);
    return 0;
}
