#include <stdio.h>

#define MAXN 100
int l = 0, d[MAXN + 1], nofd[4], tour[4][MAXN];

void display()
{
    int i, j;

    for(i = 0; i < 4; i++) {
	printf("%d: ", i + 1);
	for(j = 0; j < nofd[i]; j++) printf("%d ", tour[i][j]);
	printf("\n");
    }
    printf("\n");

}

void hanoi3(int n, int t1, int t2, int t3)
{
    if(n == 0) return;
    hanoi3(n - 1, t1, t3, t2);
//    printf("%d: %d -> %d\n", l, t1, t3);
    nofd[t1]--;
    tour[t3][nofd[t3]] = tour[t1][nofd[t1]];
    nofd[t3]++; l++;
    display();
    hanoi3(n - 1, t2, t1, t3);
}

void hanoi4(int n, int t1, int t2, int t3, int t4)
{
    int dd, nn;

    if(n == 0) return;
    dd = d[n]; nn = n - dd;
    hanoi4(nn, t1, t2, t4, t3);
    hanoi3(dd, t1, t2, t4);
    hanoi4(nn, t3, t1, t2, t4);
}

main(int argc, char *argv[])
{
    int i, j, m, n;

    if(argc > 1) {
	if((n = atoi(argv[1])) > MAXN || n < 1) exit(0);
    }
    else n = 5;
    for(i = m = 1; ; i++) {
	for(j = 1; j <= i + 1; j++) {
	    d[m++] = i;
	    if(m > n) break;
	}
	if(j <= i + 1) break;
    }
    for(i = 0; i < n; i++) tour[0][i] = n - i;
    nofd[0] = n;
    for(i = 1; i < 4; i++) nofd[i] = 0;
    display();
    hanoi4(n, 0, 1, 2, 3);
    printf("%d ΰư\n", l);
    return 0;
}
