#include <stdio.h>

#define MAXN 11
int l = 0, d[MAXN + 1], nofd[4], tour[4][MAXN], adp = 0;

void display()
{
    int i, j;

    printf("gray 0.\n");
    for(i = 0; i < 4; i++) {
      printf("polygon %f -10. %f 10. %f 10. %f -10.\n", -20.8 + 14. * i, -20.8 + 14. * i, -21.2 + 14. * i, -21.2 + 14. * i);
    }
    printf("gray .5\n");
    for(i = 0; i < 4; i++) {
	for(j = 0; j < nofd[i]; j++) printf("polygon %f %f %f %f %f %f %f %f\n", -21. + 14. * i + .5 * tour[i][j], -10. + j, -21. + 14. * i + .5 * tour[i][j], -9. + j, -21. + 14. * i - .5 * tour[i][j], -9. + j, -21. + 14. * i - .5 * tour[i][j], -10. + j);
    }
}

void hanoi3(int n, int t1, int t2, int t3)
{
    if(n == 0) return;
    hanoi3(n - 1, t1, t3, t2);
    printf("color 3 0 0\nconnect %f 11 %f 11\n", -21. + 14. * t1, -21. + 14. * t3);
    if(t1 < t3) printf("polygon %f 11 %f 11.5 %f 10.5\n", -21. + 14. * t3, -21.5 + 14. * t3, -21.5 + 14. * t3);
    else printf("polygon %f 11 %f 11.5 %f 10.5\n", -21. + 14. * t3, -20.5 + 14. * t3, -20.5 + 14. * t3);
    printf("gray 0.\nText 0 20 %d : %d -> %d\ndisplay %d\nsleep 1\n", l, t1 + 1, t3 + 1, adp);
    nofd[t1]--;
    tour[t3][nofd[t3]] = tour[t1][nofd[t1]];
    nofd[t3]++; l++;
    if(adp == 0) adp = 1;
    else adp = 0;
    printf("active %d\nclear\n", adp);
    display();
    hanoi3(n - 1, t2, t1, t3);
}

void hanoi4(int n, int t1, int t2, int t3, int t4)
{
    int dd, nn;

    if(n == 0) return;
    dd = d[n]; nn = n - dd;
    hanoi4(nn, t1, t2, t4, t3);
    hanoi3(dd, t1, t2, t4);
    hanoi4(nn, t3, t1, t2, t4);
}

main(int argc, char *argv[])
{
    int i, j, m, n;

    if(argc > 1) {
	if((n = atoi(argv[1])) > MAXN || n < 1) exit(0);
    }
    else n = 5;
    for(i = m = 1; ; i++) {
	for(j = 1; j <= i + 1; j++) {
	    d[m++] = i;
	    if(m > n) break;
	}
	if(j <= i + 1) break;
    }
    for(i = 0; i < n; i++) tour[0][i] = n - i;
    nofd[0] = n;
    for(i = 1; i < 4; i++) nofd[i] = 0;
    display();
    hanoi4(n, 0, 1, 2, 3);
    printf("gray 0.\nText 5 20 %dtimes\ndisplay %d\n", l, adp);
    return 0;
}
