#include <stdio.h>

#define MAXN 12

int l = 1, d4[MAXN + 1], d5[MAXN + 1];

void hanoi3(int n, int t1, int t2, int t3)
{
    if(n == 0) return;
    hanoi3(n - 1, t1, t3, t2);
    printf("%d: %d -> %d\n", l++, t1, t3);
    hanoi3(n - 1, t2, t1, t3);
}

void hanoi4(int n, int t1, int t2, int t3, int t4)
{
    int dd, nn;

    if(n == 0) return;
    dd = d4[n]; nn = n - dd;
    hanoi4(nn, t1, t2, t4, t3);
    hanoi3(dd, t1, t2, t4);
    hanoi4(nn, t3, t1, t2, t4);
}

void hanoi5(int n, int t1, int t2, int t3, int t4, int t5)
{
    int dd, nn;

    if(n == 0) return;
    dd = d5[n]; nn = n - dd;
    hanoi5(nn, t1, t2, t3, t5, t4);
    hanoi4(dd, t1, t2, t3, t5);
    hanoi5(nn, t4, t1, t2, t3, t5);
}

main(int argc, char *argv[])
{
    int i, j, m, n;

    if(argc > 1) {
	if((n = atoi(argv[1])) > MAXN || n < 1) exit(0);
    }
    else n = 5;
    for(i = m = 1; ; i++) {
	for(j = 1; j <= i + 1; j++) {
	    d4[m++] = i;
	    if(m > n) break;
	}
	if(j <= i + 1) break;
    }
    d5[1] = d5[2] = 1; d5[3] = 2;
    for(i = 4; i < 8; i++) d5[i] = 3;
    d5[8] = 4; d5[9] = 5;
    for(i = 10; i < 13; i++) d5[i] = 6;
    hanoi5(n, 1, 2, 3, 4, 5);
    return 0;
}
