#include <stdio.h>
#include <stdlib.h>

#define MAXN 20
#define MGH 100
#define MGH2 50

int toir[3][MAXN], height[3], n;
struct COL {
    int r, g, b;
} col[MAXN];

void ex(int left, int middle, int right, int n);
void move(int a, int b);

main(int argc, char *argv[])
{
    int i;

    if(argc > 1) n = atoi(argv[1]);
    else n = 3;
    if(n >MAXN) return 0;
    height[0] = n; height[1] = height[2] = 0;
    for(i = 0; i < n; i++) {
	col[i].r = col[i].g = col[i].b = i/3;
	if((i%3) == 0) col[i].r++;
	else if((i%3) == 1) col[i].g++;
	else col[i].b++;
    }
    printf("color 1 1 1\n");
    printf("polygon 10 %d 590 %d 590 %d 10 %d\n", MGH + 20 * n - 10, MGH + 20 * n - 10, MGH + 20 * n, MGH + 20 * n);
    for(i = 0; i < n; i++) {
	printf("color %d %d %d\n", col[i].r, col[i].g, col[i].b);
	printf("polygon %d %d %d %d %d %d %d %d\n", 
	       100 - 5 * (i + 1), MGH + 20 * i - 10, 
	       100 + 5 * (i + 1), MGH + 20 * i - 10, 
	       100 + 5 * (i + 1), MGH + 20 * i + 10, 
	       100 - 5 * (i + 1), MGH + 20 * i + 10);
    }
    printf("color 0 0 0\n");
    printf("polygon 98 30 102 30 102 60 98 60\n");
    printf("polygon 298 30 302 30 302 %d 298 %d\n", 20 * n + MGH - 10, 20 * n + MGH - 10);
    printf("polygon 498 30 502 30 502 %d 498 %d\n", 20 * n + MGH - 10, 20 * n + MGH - 10);
    ex(0, 1, 2, n);
    return 0;
}

void ex(int left, int middle, int right, int n)
{
    if(n == 0) return;
    ex(left, right, middle, n - 1);
/*    printf(" move from %d to %d\n", left, right); */
    move(left, right);
/*    display(); */
    ex(middle, left, right, n - 1);
}

void move(int a, int b)
{
    int cr, cg, cb, x1, x2, x3, x4, y, i;

    toir[b][height[b]++] = toir[a][--height[a]];
    cr = col[toir[b][height[b] - 1]].r;
    cg = col[toir[b][height[b] - 1]].g;
    cb = col[toir[b][height[b] - 1]].b;
    x1 = 100 + 200 * a - 5 * (toir[b][height[b] - 1] + 1);
    x2 = 100 + 200 * a + 5 * (toir[b][height[b] - 1] + 1);
    x3 = 98 + 200 * a;
    x4 = 102 + 200 * a;
    y = 5 * (toir[b][height[b] - 1] + 1);
    for(i = MGH + 20 * (n - height[a] - 1); i > 20; i--) {
	printf("color 3 3 3\n");
	printf("connect %d %d %d %d\n", x1, i + 10, x2, i + 10);
	printf("color %d %d %d\n", cr, cg, cb);
	printf("connect %d %d %d %d\n", x1, i - 11, x2, i - 11);
	if(i > MGH2 - 10) {
	    printf("color 0 0 0\n");
	    printf("connect %d %d %d %d\n", x3, i + 10, x4, i + 10);
	}
    }
    if(a < b) {
	for(i = 100 + 200 * a; i <= 100 + 200 * b; i++) {
	    printf("color 3 3 3\n");
	    printf("connect %d 10 %d 30\n", i - y, i - y);
	    printf("color %d %d %d\n", cr, cg, cb);
	    printf("connect %d 10 %d 30\n", i + y, i + y);
	}
    }
    else {
	for(i = 100 + 200 * a; i >= 100 + 200 * b; i--) {
	    printf("color 3 3 3\n");
	    printf("connect %d 10 %d 30\n", i + y, i + y);
	    printf("color %d %d %d\n", cr, cg, cb);
	    printf("connect %d 10 %d 30\n", i - y, i - y);
	}
    }
    x1 = 100 + 200 * b - 5 * (toir[b][height[b] - 1] + 1);
    x2 = 100 + 200 * b + 5 * (toir[b][height[b] - 1] + 1);
    x3 = 98 + 200 * b;
    x4 = 102 + 200 * b;
    for(i = 20; i < MGH + 20 * (n - height[b]); i++) {
	printf("color 3 3 3\n");
	printf("connect %d %d %d %d\n", x1, i - 10, x2, i - 10);
	printf("color %d %d %d\n", cr, cg, cb);
	printf("connect %d %d %d %d\n", x1, i + 11, x2, i + 11);
	if(i > MGH2 + 10) {
	    printf("color 0 0 0\n");
	    printf("connect %d %d %d %d\n", x3, i - 10, x4, i - 10);
	}
    }
}
