/*
§ ((z^2 + 1)^2 + i((z^2 - 1)^2)^2 / ((z^2 + 1)^2 + ((z^2 - 1)^2)~2
holmap8 | drawg -s100 -w650 -h650 -x-100
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "complexn2.h"

#define MAXN 20

CPX root(int n, CPX c[])
{
    int i;
    CPX z, z2, pz, f, df;

    for(z.r = 10., z.i = 1.; ; z = z2) {
        for(i = 1, pz = z, f = c[0], df = c[1]; i < n; i++, pz = pz * z) {
	    f += c[i] * pz;
	    df += (double)(i + 1) * c[i + 1] * pz;
	}
	f += c[n] * pz;
	z2 = z - f / df;
	if(abs(z2 - z) < .000001) break;
    }
    return z2;
}

void rtofale(int n, CPX c[], CPX w[])
{
    int i;
    CPX z, c2[MAXN];

    for( ; n > 0; n--){
        z = w[n - 1] = root(n, c);
	for(i = n - 2, c2[n - 1] = c[n]; i >= 0; i--) c2[i] = c[i + 1] + c2[i + 1] * z;
	for(i = 0; i < n; i++) c[i] = c2[i];
    }
    return;
}

CPX ft(CPX z)
{
    CPX z2, z2p1, z2m1, w, u, v, im;

    z2 = z * z; z2p1 = z2 + 1.; z2m1 = z2 - 1.;
    im.r = 0.; im.i = 1.;
    u = z2p1 * z2p1; v = z2m1 * z2m1;
    w = (u + im * v) / (u + v);
    return w * w;
}

main(int argc, char *argv[])
{
    int i;
    double x, y, ab;
    CPX z, w;

    for(x = -1.8; x <= 3.7; x += .01) {
	for(y = -2.9; y <= 2.9; y += .01) {
	    z.r = x; z.i = y;
	    w = ft((2. * z - 2.) / (z + 1.));
	    if(w.i > 0.) {
		printf("point %f %f\n", x, y);
	    }
	}
    }
    return 0;
}
