#include <stdio.h>
#include <math.h>

#define DIM 4
#define MAXV 1000
#define MAXF 1000

struct PT {
    double x[DIM];
} vt[MAXV];

struct FACE {
    int a[DIM];
} face[MAXF];

int nv = DIM, nf = 1;
double alpha;

int alexvt()
{
    int i, j;
    double x, z;

    for(i = 0; i < nv; i++) {
	z = 0.;
	for(j = 0; j < DIM; j++) {
	    x = vt[i].x[j] - vt[nv].x[j];
	    z += x * x;
	}
	if(z < .0001) return i;
    }
    return -1;
}

int alexface()
{
    int i, j;

    for(i = 0; i < nf; i++) {
	for(j = 0; j < DIM; j++) if(face[i].a[j] != face[nf].a[j]) break;
	if(j == DIM) return i;
    }
    return -1;
}

void search(int f)
{
    int i, j, k, l, m;

    for(i = 0; i < DIM; i++) {
	for(k = 0; k < DIM; k++) vt[nv].x[k] = 0.;
	for(j = 0; j < DIM; j++) {
	    if(i == j) {
		for(k = 0; k < DIM; k++) vt[nv].x[k] -= vt[face[f].a[i]].x[k];
	    }
	    else {
		for(k = 0; k < DIM; k++) vt[nv].x[k] += alpha * vt[face[f].a[j]].x[k];
	    }
	}
	if((l = alexvt()) == -1) {
	    printf("%d : (", nv);
	    for(k = 0; k < DIM; k++) printf("%3.3f, ", vt[nv].x[k]);
	    printf(")\n");
	    for(k = 0; k < i; k++) face[nf].a[k] = face[f].a[k];
	    for( ; k < DIM - 1; k++) face[nf].a[k] = face[f].a[k + 1];
	    face[nf].a[DIM - 1] = nv;
	    nv++;
	    if(nv >= MAXV) exit(0);
	}
	else {
	    for(k = 0; k < DIM; k++) face[nf].a[k] = face[f].a[k];
	    if(face[f].a[i] < l) {
		for(k = i + 1; k < DIM; k++) {
		    if(face[nf].a[k] > l) break;
		    face[nf].a[k - 1] = face[nf].a[k];
		}
		face[nf].a[k - 1] = l;
	    }
	    else {
		for(k = i - 1; k >= 0; k--) {
		    if(face[nf].a[k] < l) break;
		    face[nf].a[k + 1] = face[nf].a[k];
		}
		face[nf].a[k + 1] = l;
	    }
	}
	if(alexface() == -1) {
	    printf("f%d : ", nf);
	    for(k = 0; k < DIM; k++) printf("%d ", face[nf].a[k]);
	    printf("\n");
	    nf++;
	    if(nf >= MAXF) exit(0);
	    search(nf - 1);
	}
    }
}

main()
{
    int i, j;

    alpha = sin(4.* M_PI / 5.) / sin(2.* M_PI / 5.);
    for(i = 0; i < DIM; i++) {
	for(j = 0; j < DIM; j++) {
	    if(i == j) vt[i].x[j] = 1.;
	    else vt[i].x[j] = 0.;
	}
    }
    for(i = 0; i < DIM; i++) face[0].a[i] = i;
    search(0);
    printf("nv = %d, nf = %d\n", nv, nf);
    return 0;
}
