#include <stdio.h>

void solv(int a, int b, int *x, int *y)
{
    int c;

    c = a % b;
    if(c == 0) {
	*x = 0; *y = 1;
	return;
    }
    solv(b, c, y, x);
    *y -= *x * (a / b);
    return;
}

main(int argc, char *argv[])
{
    int a, b, n, x, y;

    if(argc < 3) {
	fprintf(stderr, "Two paramater needed\n");
	exit(0);
    }
    a = atoi(argv[1]);
    b = atoi(argv[2]);
    n = gcd(a, b);
    if(a > b) solv(a, b, &x, &y);
    else solv(b, a, &y, &x);
    printf("%d * %d + %d * %d = %d\n", a, x, b, y, n);
    if(a * x + b * y == n) printf("OK\n");
    return 0;
}
