#include <stdio.h>

void solv(int a, int b, int *x, int *y)
{
    int c;

    if(a > b) {
	c = a % b;
	if(c == 0) {
	    *x = 0; *y = 1;
	    return;
	}
	solv(c, b, x, y);
	*y -= *x * (a / b);
	return;
    }
    else {
	c = b % a;
	if(c == 0) {
	    *x = 1; *y = 0;
	    return;
	}
	solv(a, c, x, y);
	*x -= *y * (b / a);
	return;
    }
}

int inv(int a, int n)
{
    int x, y;

    if(gcd(a, n) > 1) return -1;
    solv(a, n, &x, &y);
    for( ; ; ) {
	if(x > 0) break;
	x += n;
    }
    x %= n;
    return x;
}

main(int argc, char *argv[])
{
    int a, n, x;

    if(argc < 3) {
	fprintf(stderr, "Two paramater needed\n");
	exit(0);
    }
    a = atoi(argv[1]);
    n = atoi(argv[2]);
    if((x = gcd(a, n)) > 1) {
	printf("gcd(%d, %d) = %d\n", a, n, x);
	exit(0);
    }
    x = inv(a, n);
    if(((a * x) % n) == 1) printf("%d * %d = 1 mod %d\n", a, x, n);
    return 0;
}
