#include <stdio.h>

#define DIM 4

int isolv4x3(int a[], int s[])
{
    int i, j, k, tmp, g;

    for(i = 0; i < 3; i++) {
        for(j = i; j < 3; j++) if(a[j * DIM + i] != 0) break;
	if(j == 3) return 0;
	if(j > i) {
	    for(k = i; k < DIM; k++) {
	        tmp = a[i * DIM + k];
		a[i * DIM + k] = a[j * DIM + k];
		a[j * DIM + k] = tmp;
	    }
	}
	for(j = i + 1; j < 3; j++) {
	    for(k = i + 1; k < DIM; k++) {
	        a[j * DIM + k] *= a[i * DIM + i];
		a[j * DIM + k] -= a[j * DIM + i] * a[i * DIM + k];
	    }
	    g = gcd(a[j * DIM + i + 1], a[j * DIM + i + 2]);
	    for(k = i + 3; k < DIM; k++) g = gcd(g, a[j * DIM + k]);
	    for(k = i + 1; k < DIM; k++) a[j * DIM + k] /= g;
	}
    }
    s[3] = a[2 * DIM + 2];
    s[2] = -a[2 * DIM + 3];
    tmp = s[2] * a[DIM + 2] + s[3] * a[DIM + 3];
    g = gcd(tmp, a[DIM + 1]);
    s[1] = -tmp / g;
    s[2] *= a[DIM + 1] / g;
    s[3] *= a[DIM + 1] / g;
    tmp = s[1] * a[1] + s[2] * a[2] + s[3] * a[3];
    g = gcd(tmp, a[0]);
    s[0] = -tmp / g;
    s[1] *= a[0] / g;
    s[2] *= a[0] / g;
    s[3] *= a[0] / g;
    if(s[DIM - 1] < 0) for(k = 0; k < DIM; k++) s[k] *= -1;
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, a[3 * DIM], s[DIM];

    for(i = 0; i < 3; i++) {
        for (j = 0; j < DIM; j++) scanf("%d", a + DIM * i + j);
    }
    if(isolv4x3(a, s) == 0) printf("Error\n");
    for(i = 0; i < 3; i++) printf("%d %d %d %d\n", a[i * DIM], a[i * DIM + 1], a[i * DIM + 2], a[i * DIM + 3]);
    printf("%d %d %d %d\n", s[0], s[1], s[2], s[3]);
    return 0;
}
