#include <stdio.h>
#include <stdlib.h>
#include<math.h>

int m, n;

double f(double t)
{
    return cos(m * t);
}

double g(double t)
{
    return sin(n * t);
}

double df(double t)
{
    return -m * sin(m * t);
}

double dg(double t)
{
    return n * cos(n * t);
}

double d2f(double t)
{
    return -m * m * cos(m * t);
}

double d2g(double t)
{
    return -n * n * sin(n * t);
}

main(int argc, char *argv[])
{
    int adp = 1, i, NN = 400;
    double t, s = 0., a, b, c, dt = M_PI / NN, x, y, x2, y2, k, k0, sk0;

    if(argc > 1) m = atoi(argv[1]);
    else m = 1;
    if(argc > 2) n = atoi(argv[2]);
    else n = 2;
    printf("circle 1.5 0 .3\ncolor 0 3 0\nline 1 0 -1\nconnect 1.5 .3 1.5 -.3\ncolor 0 0 0\n");
/*
    printf("color 1 3 0\n");
*/
    for(t = 0; t < 2 * M_PI; t += .001) printf("point %f %f\n", f(t), g(t));
    printf("pause\n");
    for(t = 0, i = 1; t < 2 * M_PI; t += dt, i++) {
	if((i % 201) == 0) printf("pause\n");
        x = f(t); y = g(t);
	a = dg(t); b = -df(t); c = -a * x - b * y;
	x2 = d2f(t); y2 = d2g(t);
	k0 = (a * a + b * b);
	k = (y2 * b + x2 * a) / k0;
	printf("active %d\n", adp);
	printf("copy 0 %d\n", adp);
	if(k > 0) printf("color 0 0 3\n");
	else printf("color 3 0 0\n");
	printf("point %f %f\n", x, y);
	printf("line %f %f %f\n", a, b, c);
	sk0 = sqrt(k0);
	printf("connect %f %f %f %f\n", 1.5 + .3 * b / sk0, -.3 * a / sk0, 1.5 - .3 * b / sk0, .3 * a / sk0);
	s -= dt * k;
	printf("color 0 0 0\nText 0 20 %.3f=%.3f * 2 * pi\nText 0 40 k=%.3f\n", s, s / (2. * M_PI), -k / sk0);
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }

    return 0;
}
