#include <stdio.h>
#include <stdlib.h>
#include<math.h>

int n;

double f(double t)
{
    return cos(n * t) * cos(t);
}

double g(double t)
{
    return cos(n * t) * sin(t);
}

double df(double t)
{
    return -n * sin(n * t) * cos(t) - cos(n * t) * sin(t);
}

double dg(double t)
{
    return -n * sin(n * t) * sin(t) + cos(n * t) * cos(t);
}

double d2f(double t)
{
    return -(n * n + 1) * cos(n * t) * cos(t) + 2 * n * sin(n * t) * sin(t);
}

double d2g(double t)
{
    return -(n * n + 1) * cos(n * t) * sin(t) - 2 * n * sin(n * t) * cos(t);
}

main(int argc, char *argv[])
{
    int adp = 1;
    double t, s = 0., a, b, c, dt = .003, x2, y2, k, k0;

    if(argc > 1) n = atoi(argv[1]);
    else n = 2;
    for(t = 0; t < 2 * M_PI; t += .001) printf("point %f %f\n", f(t), g(t));
    printf("pause\nactive 1\ncolor 0 0 3\n");
    for(t = 0; t < 2 * M_PI; t += dt) {
	printf("copy 0 %d\n", adp);
	a = dg(t); b = -df(t); c = -a * f(t) - b * g(t);
	printf("line %f %f %f\n", a, b, c);
	x2 = d2f(t); y2 = d2g(t);
	k0 = (a * a + b * b);
	k = (y2 * b + x2 * a) / k0;
	s -= dt * k;
	printf("Text 0 20 %.3f=%.3fpi\nText 0 40 k=%.3f\n", s, s / M_PI, -k / sqrt(k0));
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\n", adp);
    }
    return 0;
}
