#include <stdio.h>
#include<math.h>

int m, n;

double f(double t)
{
    return cos(m * t);
}

double g(double t)
{
    return sin(n * t);
}

double df(double t)
{
    return -m * sin(m * t);
}

double dg(double t)
{
    return n * cos(n * t);
}

double d2f(double t)
{
    return -m * m * cos(m * t);
}

double d2g(double t)
{
    return -n * n * sin(n * t);
}

main(int argc, char *argv[])
{
    int adp = 1;
    double t, dfdt, dgdt, d2fdt2, d2gdt2, df2dg2, kappa, lgt, x, y, kp;

    if(argc > 1) m = atoi(argv[1]);
    else m = 1;
    if(argc > 2) n = atoi(argv[2]);
    else n = 2;
    printf("Text 5 30 x = cos %dt y = sin %dt\n", m, n);
    for(t = 0; t < 2 * M_PI; t += .001) printf("point %f %f\n", f(t), g(t));
    printf("color 3 0 0\n");
    for(t = 0; t < 2 * M_PI; t += .03) {
	dfdt = df(t); dgdt = dg(t);
	d2fdt2 = d2f(t); d2gdt2 = d2g(t);
	df2dg2 = dfdt * dfdt + dgdt * dgdt;
	lgt = sqrt(df2dg2);
	kappa = (dfdt * d2gdt2 - dgdt * d2fdt2) / (df2dg2 * lgt);
        printf("active %d\ncopy 0 %d\ncolor 3 0 0\nText 5 60 t=%2.3f\n", adp, adp, t);
	printf("disk %f %f .02\n", x = f(t), y = g(t));
	printf("color 0 0 3\nText 5 80 k=%2.3f\n", kappa);
	if((kappa < -.01 || kappa > .01) && lgt > .001) {
	    if(kappa > 0.) kp = 1. / kappa;
	    else kp = -1. / kappa;
	    printf("circle %2.3f %2.3f %2.3f\n", x - dgdt / (kappa * lgt), y + dfdt / (kappa * lgt), kp);
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
