#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int m = 1;

double xx(double t)
{
    return cos(m * t) * cos(t);
}

double yy(double t)
{
    return cos(m * t) * sin(t);
}

main(int argc, char *argv[])
{
    double t, dt = M_PI / 500., x0, y0, x1, y1;

    if(argc > 1) m = atoi(argv[1]);
    x0 = xx(0.); y0 = yy(0.);
    for(t = dt; t < 2 * M_PI; t += dt) {
        x1 = xx(t);
	y1 = yy(t);
        printf("connect %f %f %f %f\n", x0, y0, x1, y1);
	x0 = x1; y0 = y1;
    }
    return 0;
}
