#include <stdio.h>
#include <math.h>

#define DT .00001

int m = 1, n = 1;

double ft(double t)
{
    double x, y;

    x = -m * sin(m * t);
    y = n * cos(n * t);
    return sqrt(x * x + y * y);
}

int main(int argc, char *argv[])
{
    double t, lgth = 0.;

    if(argc > 1) m = atoi(argv[1]);
    if(argc > 2) n = atoi(argv[2]);
    for(t = DT; t < 2. * M_PI; t += DT) {
	lgth += ft(t) * DT;
    }
    printf("length = %f = %3.2f pi\n", lgth, lgth / M_PI);
    return 0;
}
