#include <stdio.h>
#include <stdlib.h>

#define MAXL 1024
#define MNW 40
#define MNC 10
#define MD 1000

void reduct(char *s);
int findword(char *s, char *word);
int len(char *s);
int cmpword(char *w1, char *w2);

int deg, nc, nwd, m;
char elset[MAXL * MD], *pe[MD], *words1[MNW], *words2[MNW], 
	s[MAXL], s2[MAXL], wdset[MNW * 20];

int main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, k;
	char *p, *q, *r;
	void reduct();

	if(argc <= 2) {
		fprintf(stderr, "Two parameter needed\n");
		exit(0);
	}
	nc = atoi(argv[1]);
	if(nc > MNC) {
		fprintf(stderr, "The number of characters must be smaller than %d\n", MNC);
		exit(0);
	}
	nwd = atoi(argv[2]);
	if(nwd > MNW) {
		fprintf(stderr, "The number of words must be smaller than %d\n", MNW);
		exit(0);
	}
	p = wdset;
	for(i = 0; i < nwd; i++) {
		scanf("%s", p);
		words1[i] = p;
		for( ; *p != '='; ) p++;
		*(p++) = '\0';
		words2[i] = p;
		p += len(p) + 1;
	}
/*	for(i = 0; i < nwd; i++) fprintf(stderr, "%s=%s\n", words1[i], words2[i]);
*/	p = pe[0] = elset; elset[0] = '\0';
	for(deg = 1, m = 0, p++; m < deg; m++) {
		for(j = 0; j < nc; j++) {
			q = p;
			*(q++) = 'a' + j;
			r = pe[m];
			for( ; ; q++, r++) if((*q = *r) == '\0') break;
			reduct(p);
			for(k = 0; k < deg; k++) if(cmpword(p, pe[k]) == 1) break;
			if(k == deg) {
				pe[deg++] = p;
				if(deg > MD) {
					fprintf(stderr, "The degree exceeds %d\n", MD);
					exit(0);
				}
				p += len(p) + 1;
			}
		}
	}
	for(i = 0; i < deg; i++) {
	    if((i % 5) == 4) fprintf(stderr, "%d:%s\n", i, pe[i]);
	    else fprintf(stderr, "%d:%s\t\t", i, pe[i]);
	}
	fprintf(stderr, "\n");
	for(i = 0; i < deg; i++) {
		for(j = 0; j < deg; j++) {
			for(p = s, q = pe[i]; ; p++, q++) if((*p = *q) == '\0') break;
			for(q = pe[j]; ; p++, q++) if((*p = *q) == '\0') break;
/*			printf("%s=", s);
*/			reduct(s);
/*			printf("%s ", s);
*/			for(k = 0; k < deg; k++) if(cmpword(s, pe[k]) == 1) break;
			printf("%d ", k);
		}
		printf("\n");
	}
	return 0;
}

void reduct(s)
	char *s;
{
	int i, j, k, l, l1, l2;
	char *p, *q;

	l = len(s);
	for( ; ; ) {
		for(i = 0; i < nwd; i++) if((j = findword(s, words1[i])) >= 0)break;
		if(i == nwd) break;
		l1 = len(words1[i]); l2 = len(words2[i]);
		if((k = l1 - l2) > 0) {
			p = s + j;
			for(; *p != '\0'; p++) *p = *(p + k);
			*p = '\0';
		}
		else if(k != 0) {
			p = s + l - k;
			for(; p > s + j; p--) *p = *(p + k);
		}
		l -= k;
		for(k = 0; k < l2; k++) *(s + j + k) = *(words2[i] + k);
	}
}

int findword(s, word)
	char *s, *word;
{
	int i, j, l, p = 0;

	l = len(word);
	for(; *s != '\0'; s ++, p++) {
		for(i = 0; i < l; i++) if(*(s + i) != *(word + i)) break;
		if(i == l) return p;
	}
	return -1;
}
	
int len(s)
	char *s;
{
	int i=0;

	while(*(s++)!='\0') i++;
	return i;
}

int cmpword(w1, w2)
	char *w1, *w2;
{
	for( ; *(w1) != '\0'; ) if(*(w1++) != *(w2++)) return -1;
	if(*(w2) == '\0') return 1;
	else return -1;
}
