#include <stdio.h>
#include <stdlib.h>

#define MD 20
#define MN (MD * 1) * (MD + 2) / 2

double c[MN], c1[MN], c2[MN];

int getpoly(int md, double c[], char *s)
{
    int x, y, d, dd = 0, top = (md + 1) * (md + 2) / 2 - 1;
    char *s0, cs, xoy;
    double f, w = 0;

    for(; *s != 0; ) {
	x = y = 0; f = 1.;
	if(*s == '+') s++;
	if(*s == '-') {
	    f = -1.;
	    s++;
	}
	for(s0 = s; ; s++) if((*s > '9' || *s < '0') && *s != '.') break;
	if((*s != 'x') && (*s != 'y') && (*s != 0) && (*s != '+') && (*s != '-')) return -1;
	if(s0 == s) w = 1.;
	else {
	    cs = *s; *s = 0;
	    w = atof(s0);
	    *s = cs;
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if((d = x + y) > md) return 0;
	if(d > dd) dd = d;
	c[top - d * (d + 1) / 2 - x] += f * w;
    }
    return dd;
}

main(int argc, char *argv[])
{
    int i, d, d1, d2, m, top, x, y, x1, y1, x2, y2, j1, k1, j2, k2, n, f = 0;
    double z;

    if(argc < 2) exit(0);
    top = (MD + 1) * (MD + 2) / 2 - 1;
    for(i = 0; i <= top; i++) c[i] = 0.;
    d = getpoly(MD, c, argv[1]);
    for(n = 2; n < argc; n++) {
        for(i = 0; i <= top; i++) {
	    c1[i] = c[i];
	    c[i] = c2[i] = 0.;
	}
	d1 = d;
	d2 = getpoly(MD, c2, argv[n]);
	d = d1 + d2;
	m = (d + 1) * (d + 2) / 2;
	for(j1 = k1 = 0; j1 <= d1; j1++) {
            for(y1 = j1; y1 >= 0; y1--, k1++) {
	        x1 = j1 - y1;
		for(j2 = k2 = 0; j2 <= d2; j2++) {
	            for(y2 = j2; y2 >= 0; y2--, k2++) {
		        x2 = j2 - y2;
			x = x1 + x2;
			y = y1 + y2;
			i = x + y;
			c[top - (i + 1) * i / 2 - x] += c1[top - k1] * c2[top - k2];
		    }
		}
	    }
	}
    }
    f = 0;
    for(i = d; i >= 0; i--) {
        for(x = i; x >= 0; x--) {
	  y = i - x;
	  z = c[top - (i + 1) * i / 2 - x];
	  if(z == 0.) continue;
	  if(f == 0) f = 1;
	  else if(z > 0.) printf("+");
	  printf("%3.4f", z);
	  if(x > 0) printf("x");
	  if(x > 1) printf("%d", x);
	  if(y > 0) printf("y");
	  if(y > 1) printf("%d", y);
	}
    }
    printf("\n");
    return 0;
}
