#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 20
#define gosa .0000001
#define SX0 1.12

typedef struct line {
    double a, b, c;
} LINE;

typedef struct pointin2d {
    double x, y;
} P2D;

typedef struct circle {
    double x, y, r;
} CIRC;

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}

main(int argc, char *argv[])
{
    int i, m = 1, n = 3, adp = 1;
    double t, t0, t2, x0, y0, x2, y2, x1, y1, xx, yy;
    P2D pt[MAXN];
    LINE ln[MAXN];
    CIRC circ;

    if(argc > 1) n = atoi(argv[1]);
    if(n < 3 || n >MAXN) exit(0);
    if(argc > 2) {
        m = atoi(argv[2]);
	if(gcd(m, n) != 1 || 2 * m > n) m = 1;
    }
    circ.y = 0.;
    for(circ.r = 1.1; ; circ.r += .001) {
	circ.x = SX0 - circ.r;
	printf("active %d\nclear\ncolor 0 0 0\ncircle 0 0 1.\ncircle %f 0. %f\ncolor 0 0 3\n", adp, circ.x, circ.r);
	for(x0 = SX0, y0 = 0., t = 0., i = 0; i < n; i++) {
	    xx = x0 * x0; yy = y0 * y0;
	    x1 = (x0 - y0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    y1 = (y0 + x0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    if((t2 = y1 - y0) < gosa && t2 > -gosa) t2 = M_PI / 2.;
	    else t2 = atan((x0 - x1) / t2);
	    for(;t2 < t;) t2 += M_PI;
/*
	    fprintf(stderr, "%3.4f ", t);
	    fprintf(stderr, "%3.4f  ", t2);
*/
	    t2 = 2 * t2 - t;
	    x1 = circ.x + circ.r * cos(t2);
	    y1 = circ.y + circ.r * sin(t2);
	    printf("connect %3.4f %3.4f %3.4f %3.4f\n", x0, y0, x1, y1);
	    x0 = x1; y0 = y1; t = t2;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
/*
	fprintf(stderr, "%3.4f\n", t);
*/
	if(t > 2 * M_PI * m || t < 0.) break;
    }
    if(adp == 1) adp = 2;
    else adp = 1;
    printf("pause\ncopy %d 0\ncolor 3 0 0\n", adp);
    for(t0 = 0.; t0 < M_PI; t0 += .01) {
	printf("copy 0 %d\nactive %d\n", adp, adp);
	x0 = circ.x + circ.r * cos(t0);
	y0 = circ.y + circ.r * sin(t0);
	for(t = t0, i = 0; i < n; i++) {
	    xx = x0 * x0; yy = y0 * y0;
	    x1 = (x0 - y0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    y1 = (y0 + x0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    if((t2 = y1 - y0) < gosa && t2 > -gosa) t2 = M_PI / 2.;
	    else t2 = atan((x0 - x1) / t2);
	    for(;t2 < t;) t2 += M_PI;
/*
	    fprintf(stderr, "%3.4f ", t);
	    fprintf(stderr, "%3.4f  ", t2);
*/
	    t2 = 2 * t2 - t;
	    x1 = circ.x + circ.r * cos(t2);
	    y1 = circ.y + circ.r * sin(t2);
	    printf("connect %3.4f %3.4f %3.4f %3.4f\n", x0, y0, x1, y1);
	    x0 = x1; y0 = y1; t = t2;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
/*
	fprintf(stderr, "%3.4f\n", t);
*/
    }
/*
    printf("pause\nactive 0\nclear\ncolor 0 0 0\ncircle 0 0 1.\n");
    for(; circ.x < circ.r - 1.05; circ.x += .003) {
	printf("copy 0 %d\nactive %d\ncolor 0 0 0\ncircle %f 0. %f\ncolor 0 0 3\n", adp, adp, circ.x, circ.r);
	x0 = circ.x + circ.r;
	y0 = circ.y;
	for(t = 0., i = 0; i < n; i++) {
	    xx = x0 * x0; yy = y0 * y0;
	    x1 = (x0 - y0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    y1 = (y0 + x0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    if((t2 = y1 - y0) < gosa && t2 > -gosa) t2 = M_PI / 2.;
	    else t2 = atan((x0 - x1) / t2);
	    for(;t2 < t;) t2 += M_PI;
	    t2 = 2 * t2 - t;
	    x1 = circ.x + circ.r * cos(t2);
	    y1 = circ.y + circ.r * sin(t2);
	    printf("connect %3.4f %3.4f %3.4f %3.4f\n", x0, y0, x1, y1);
	    x0 = x1; y0 = y1; t = t2;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
*/
    return 0;
}
