#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 20
#define gosa .0000001
#define SX0 .12

typedef struct line {
    double a, b, c;
} LINE;

typedef struct pointin2d {
    double x, y;
} P2D;

typedef struct circle {
    double x, y, r;
} CIRC;

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.b * l2.c - l2.b * l1.c) / d;
    (*p).y = (l1.c * l2.a - l2.c * l1.a) / d;
    return 1;
}

int ptline(P2D p1, P2D p2, LINE *l)
{
    double dx;

    if(((dx = p1.x - p2.x) < gosa) && (dx > -gosa)) {
	(*l).a = 1.; (*l).b = 0.; (*l).c = -p1.x;
    }
    else {
	(*l).a = p1.y - p2.y;
	(*l).b = p2.x - p1.x;
	(*l).c = p1.x * p2.y - p2.x * p1.y;
    }
    return 1;
}

P2D pt[MAXN];
LINE ln[MAXN];

main(int argc, char *argv[])
{
    int i, j, m = 1, n = 3, adp = 1;
    double t, t0, t2, x0, y0, x1, y1, xx, yy, sx;
    P2D p0, p1;
    CIRC circ;

    if(argc > 1) n = atoi(argv[1]);
    if(n < 3 || n >MAXN) exit(0);
    if(argc > 2) {
        m = atoi(argv[2]);
	if(gcd(m, n) != 1 || 2 * m > n) m = 1;
    }
    circ.y = 0.;
    sx = 1. + SX0 * m;
    for(circ.r = 1. + m * .2; ; circ.r += .001) {
	circ.x = sx - circ.r;
	printf("active %d\nclear\ncolor 0 0 0\ncircle 0 0 1.\ncircle %f 0. %f\ncolor 0 0 3\n", adp, circ.x, circ.r);
	for(x0 = sx, y0 = 0., t = 0., i = 0; i < n; i++) {
	    xx = x0 * x0; yy = y0 * y0;
	    x1 = (x0 - y0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    y1 = (y0 + x0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    if((t2 = y1 - y0) < gosa && t2 > -gosa) t2 = M_PI / 2.;
	    else t2 = atan((x0 - x1) / t2);
	    for(;t2 < t;) t2 += M_PI;
	    t2 = 2 * t2 - t;
	    x1 = circ.x + circ.r * cos(t2);
	    y1 = circ.y + circ.r * sin(t2);
	    printf("connect %3.4f %3.4f %3.4f %3.4f\n", x0, y0, x1, y1);
	    x0 = x1; y0 = y1; t = t2;
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	if(t > 2 * M_PI * m || t < 0.) break;
    }
    if(adp == 1) adp = 2;
    else adp = 1;
    printf("pause\ncopy %d 0\ncolor 3 0 0\n", adp);
    for(t0 = 0.; t0 < M_PI; t0 += .01) {
	printf("copy 0 %d\nactive %d\n", adp, adp);
	p0.x = x0 = circ.x + circ.r * cos(t0);
	p0.y = y0 = circ.y + circ.r * sin(t0);
	for(t = t0, i = 0; i < n; i++) {
	    xx = x0 * x0; yy = y0 * y0;
	    x1 = (x0 - y0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    y1 = (y0 + x0 * sqrt(xx + yy - 1.)) / (xx + yy);
	    if((t2 = y1 - y0) < gosa && t2 > -gosa) t2 = M_PI / 2.;
	    else t2 = atan((x0 - x1) / t2);
	    for(;t2 < t;) t2 += M_PI;
	    t2 = 2 * t2 - t;
	    p1.x = x1 = circ.x + circ.r * cos(t2);
	    p1.y = y1 = circ.y + circ.r * sin(t2);
	    ptline(p0, p1, ln + i);
//	    printf("connect %3.4f %3.4f %3.4f %3.4f\n", x0, y0, x1, y1);
	    printf("line %3.4f %3.4f %3.4f\n", ln[i].a, ln[i].b, ln[i].c);
	    p0.x = x0 = x1; p0.y = y0 = y1; t = t2;
	}
	printf("active 0\n");
	for(i = 2; i < n; i++) {
	    if(i == n - 1) j = 1;
	    else j = 0;
	    for(; j < i - 1; j++) {
		if(kouten(ln[i], ln[j], &p0) == 1) printf("point %3.6f %3.6f\n", p0.x, p0.y);
	    }
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
