#include    <sys/time.h>
#include    <signal.h>

static int  wf;
struct itimerval    val,oval;

static void sleephandler(int sig)
{
    if(sig == SIGALRM){
        wf = 1;
    }
}

int msleep(int usec)
{
    if(usec == 0){
        return 0;
    }
    /* »֥ޤθͤꥢ */
    timerclear(&val.it_interval);
    timerclear(&val.it_value);
    if(setitimer(ITIMER_REAL, &val, &oval) < 0){
        return 0;
    }
    /* »֥ޤθͤȻͤӤĤ֤׻Ƥ */
    val.it_value.tv_sec = 0;
    val.it_value.tv_usec = usec;
    if(timerisset(&oval.it_value)){
        if(timercmp(&oval.it_value, &val.it_value,>)){
            oval.it_value.tv_sec -= val.it_value.tv_sec;
            oval.it_value.tv_usec -= val.it_value.tv_usec;
        }
        else{
            val.it_value = oval.it_value;
            oval.it_value.tv_sec = 1;
            oval.it_value.tv_usec = 0;
        }
    }
    /* ʥϥɥϿ */
    signal(SIGALRM, sleephandler);
    wf = 0;
    /* »֥ޤ˻֤򥻥å */
    setitimer(ITIMER_REAL, &val, (struct itimerval *)0);
    /* Ԥ */
    while(!wf){
        sigpause(SIGALRM);
    }
    /* ΥޤλĤ֤򥻥å */
    setitimer(ITIMER_REAL,&oval, (struct itimerval *)0);

    return 0;
}
