#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "geometry.h"

main(int argc, char *argv[])
{
    P2D pts[3], mpts[3], ct;
    CIRC cr;
    LINE l[3];
    int i, j;
    double s1, s2, s, r;

    if(argc <= 6) exit(0);
    for(i = 0, j = 1; i < 3; i++) {
	pts[i].x = atof(argv[j++]);
	pts[i].y = atof(argv[j++]);
    }
    printf("connect %f %f %f %f %f %f %f %f\ncolor 0 0 3\n", pts[0].x, pts[0].y, pts[1].x, pts[1].y, pts[2].x, pts[2].y, pts[0].x, pts[0].y);
    for(i = 0; i < 3; i++) {
	s1 = atan2(pts[(i + 1) % 3].y - pts[i].y, pts[(i + 1) % 3].x - pts[i].x);
	if(s1 < 0.) s1 += 2. * M_PI;
	s2 = atan2(pts[(i + 2) % 3].y - pts[i].y, pts[(i + 2) % 3].x - pts[i].x);
	if(s2 < 0.) s2 += 2. * M_PI;
	s = (s1 + s2) / 2.;
	l[i].a = sin(s); l[i].b = -cos(s); l[i].c = l[i].a * pts[i].x + l[i].b * pts[i].y;
	//	printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    }
    kouten(l[0], l[1], &ct);
    l[0].a = pts[1].y - pts[2].y;
    l[0].b = pts[2].x - pts[1].x;
    l[0].c = l[0].a * pts[1].x + l[0].b * pts[1].y;
    r = (l[0].a * ct.x + l[0].b * ct.y - l[0].c) / sqrt(l[0].a * l[0].a + l[0].b * l[0].b);
    if(r < 0.) r *= -1.;
    printf("circle %f %f %f\n", ct.x, ct.y, r);
    return 0;
}
