#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int n;
struct POINT {
    double x, y;
} pt, pt0;

double f(double t)
{
    return cos(n * t) * cos(t) * .5 + .05;
}

double g(double t)
{
    return cos(n * t) * sin(t) * .5 + .3;
}

double df(double t)
{
    return (-n * sin(n * t) * cos(t) - cos(n * t) * sin(t)) * .5;
}

double dg(double t)
{
    return (-n * sin(n * t) * sin(t) + cos(n * t) * cos(t)) * .5;
}

void draw(void)
{
    double t, f0, g0, f1, g1;

    f0 = f(0); g0 = g(0);
    printf("color 0 3 0\n");
    for(t = .01; t < 6.285; t += .01) {
	printf("connect %f %f %f %f\n", f0, g0, f1 = f(t), g1 = g(t));
	f0 = f1; g0 = g1;
    }
}

main(int argc, char *argv[])
{
    int i, j, adp = 1;
    double t, x, y, z, s = -3.1415, e = 3.15, dt = .003, x2, y2, x2y2, sx4, sy4;

/*
    if(argc > 1) s = atof(argv[1]);
    if(argc > 2) e = atof(argv[2]);
    if(argc > 3) dt = atof(argv[3]);

    printf("s = %f, e = %f, dt = %f\n", s, e, dt);
*/
    if(argc > 1) n = atoi(argv[1]);
    else n = 2;
    draw();
    printf("color 0 0 0\ncircle 0 0 1\ncopy 0 1\ndisplay %d", adp);

    for(i = 0, t = s; t <= e; t += dt, i++) {
	x = df(t); y = dg(t);
	z = f(t) * y - g(t) * x;
	if(z > .001 || z < -.001) {
	    pt.x = y / z; pt.y = -x / z;
	    printf("color 3 0 0\npoint %f %f\n", pt.x, pt.y);
	    if(i > 0 && (pt0.x * pt.x > .0 || pt0.x * pt.x > .0)) printf("connect %f %f %f %f\n", pt0.x, pt0.y, pt.x, pt.y);
	    if(adp == 1) adp = 2;
	    else adp = 1;
	    printf("copy 0 %d\nactive %d\n", adp, adp);
	    printf("color 0 0 3\nline %f %f %f\n", -y, x, z);
	    x /= z; y /= z; y2 = x * x; x2 = y * y;
	    if(x2 + y2 > 1.) {
		x2y2 = x2 + y2; sy4 = sqrt(x2 * y2 + y2 * y2 - y2); sx4 = sqrt(x2 * y2 + x2 * x2 - x2);
		if(y > 0.) {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x - sx4)/x2y2, (y + sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x + sx4)/x2y2, (y + sy4)/x2y2, (-x - sx4)/x2y2);
		}
		else {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x - sx4)/x2y2, (y - sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x + sx4)/x2y2, (y - sy4)/x2y2, (-x - sx4)/x2y2);
		}
	    }
	    pt0.x = pt.x; pt0.y = pt.y;
	}
	else pt0.x = pt0.y = 0.;
	printf("display %d\nactive 0\n", adp);
    }
    return 0;
}
