#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXNP 14
#define RD 10.
#define MAXD 15
#define gosa .0000001

typedef struct eqnofline {
	double a, b, c;
} eql;
typedef struct point {
	double x, y;
} PT;

eql eq[MAXNP];
PT w[MAXNP];
double st[MAXNP];

void draweq(eql eq);
void prl(int d1, int d2, int d3, int d4);
int isoftp(eql eq1, eql eq2, double *x, double *y);
double c[MAXD * MAXD], d[MAXD], xx[MAXD + 1], yy[MAXD + 1], x[(MAXD + 1) * MAXD], y[(MAXD + 1) * MAXD], z[MAXD];
int sle(int n, double c[], double d[]);
double solvae(int degree, double c[]);
int fdallsol(int degree, double c[], double z[]);

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, k, n, col, degree, d2, m;

	if(argc == 1) n = 6;
	else {
		n = atoi(argv[1]);
		if((n % 2) == 1 || n < 6 || n > MAXNP) return 0;
	}
	degree = n/2 - 2; m = ((degree + 1) * (degree + 2))/2 - 1;
	for(i = 0; i < n; i++) {
/*		printf("%d ܤγ", i + 1);
*/		scanf("%lf", st + i);
		w[i].x = RD * cos(st[i]); w[i].y = RD * sin(st[i]);
/*		printf("(%f, %f)\n", w[i].x, w[i].y);
*/	}
	printf("color 1 1 1\ncircle 0 0 %f\n", RD); 
	w[n].x = w[0].x; w[n].y = w[0].y;
	for(i = 0; i < n; i++) {
		double tp = w[i].x * w[i + 1].y - w[i + 1].x * w[i].y;
		if(tp == .0) {
			eq[i].a = w[i].y; eq[i].b = -w[i].x; eq[i].c = 0.;
		}
		else {
			eq[i].a = (w[i].y - w[i + 1].y)/tp;
			eq[i].b = (w[i + 1].x - w[i].x)/tp;
			eq[i].c = 1.;
		}
		if((i % 2) == 0) printf("color 0 3 0\n");
		else printf("color 0 0 3\n");
		printf("line %f %f %f\n", eq[i].a, eq[i].b, eq[i].c);
	}
	for(i = k = 0; i < n; i += 2) {
		for(j = 3; j <= n/2 + 1; j += 2) {
			if(isoftp(eq[i], eq[(i + j) % n], x + k, y + k) > 0) k++;
			if(k == m + 1) break;
		}
		if(k == m + 1) break;
	}
/*	for(i = 0; i < m; i++) {
		fprintf(stderr, "(%f, %f) ", x[i], y[i]);
	}
*/      if(k < m) return 0;
	for(i = 0; i < m; i++) d[i] = -1.;
	xx[0] = yy[0] = 1.;
	for(i = 0; i < m; i++) {
		for(j = 1; j <= degree; j++) {
			xx[j] = xx[j - 1] * x[i];
			yy[j] = yy[j - 1] * y[i];
		}
		for(j = 0, d2 = degree; d2 >= 0; d2--) {
			for(k = 0; k <= d2; k++, j++) c[i * m + j] = xx[d2 - k] * yy[k];
		}
	}
/*	for(i = 0; i < m; i++) {
		for(j = 0; j < m; j++) printf("%lf ", c[i * m + j]);
		printf(" = %lf\n", d[i]);
	}
*/	if(sle(m, c, d) < 0) {
		fprintf(stderr, "No solutions\n");
		exit(0);
	}
	d[m] = 1.;
	printf("color 3 0 0\n");
	/*
	printf("curve %d ", degree);
	for(j = 0; j <= m; j++) printf("%f ", d[j]);
	*/
	if(n > 6) {
	    printf("curve ");
	    for(k = 0, i = degree; i > 0; i--) {
		for(j = 0; j <= i; j ++) printf("%fx%dy%d+", d[k++], i - j, j);
	    }
	    printf("%f\n", d[k]);
	}
	else printf("line %f %f %f\n", d[0], d[1], d[2]);
	return 0;
}

int isoftp(eql eq1, eql eq2, double *x, double *y)
{
	double t;

	if((t = eq1.a * eq2.b - eq2.a * eq1.b) == .0) return -1;
	*x = (eq1.b * eq2.c - eq2.b * eq1.c)/t;
	*y = (eq2.a * eq1.c - eq1.a * eq2.c)/t;
	return 1;
}

int fdallsol(int degree, double c[], double z[])
{
	int i, n;

	for(n = 0; c[degree] == 0.; degree--, n++) z[n] = 0.;
	for(; degree > 0; degree--, n++) {
		if((z[n] = solvae(degree, c)) > 1000000.) break;
		for(i = 1; i < degree; i++) {
			c[i] += z[n] * c[i - 1];
		}
	}
	return n;
}

double solvae(int degree, double c[])
{
	int i, m = 0;
	double x0 = 1., f, df;

	for(; m < 100; m++) {
		for(i = 1, x[0] = 1.; i <= degree; i++) x[i] = x[i - 1] * x0;
		for(i = 1, f = c[degree]; i <= degree; i++) f += x[i] * c[degree - i];
		if(f < gosa && f > -gosa) return x0;
		for(i = 1, df = c[degree - 1]; i < degree; i++) df += (i + 1) * x[i] * c[degree - i - 1];
		if(df < gosa && df > -gosa) break;
		f /= df;
		if(f < gosa && f > -gosa) return x0;
		x0 -= f;
	}
	return 1000001.;
}
