#include <stdio.h>

#define MAX 6

int p[MAX];

void swap(int *a, int *b)
{
    int t;

    t = *a;
    *a = *b;
    *b = t;
}

int factorial(int a[], int n)
{
    int i, j;

    for(i = n - 2; i >= 0; i--){
        if(a[i] > a[i+1]) continue;
        for(j = i + 2; j < n; j++) if(a[j] < a[i]) break;
        swap(a+i,a+j-1);
        for(i++, n--; i < n;) swap(a+(i++),a+(n--));
        return 1;
    }
    return 0;
}

int sgn(int a[], int n)
{
    int i, j, f=0;
    for(i = 0; i < n-1; i++)
	for(j = i+1;j < n; j++)
	    if(a[i] > a[j]) f++;
    if((f%2) == 0) return 1;
    else return -1;
}

main(int argc, char *argv[])
{
    int i, j, n = 3;

    if(argc > 1) {
	n = atoi(argv[1]);
	if(n < 1 || n > MAX) exit(0);
    }
    for(i = 0; i < n; i++) p[i] = i;
    do {
	for(i = 0; i < n; i++) printf("%d ", p[i] + 1);
	if(sgn(p, n) == 1) printf("\t+\n");
	else printf("\t-\n");
    }while(factorial(p, n) > 0);
    return 0;
}
