#include <stdio.h>
#include <stdlib.h>

typedef struct PT{
    int x, y, z;
} ptin3d;

typedef struct PL {
    int a, b, c, d;
} plane;

int adjm(int a[], int i, int j)
{
    int c[2], r[2], k, m, f;

    if(((i + j) % 2) == 0) f = 1;
    else f = -1;
    for(k = m = 0; k < 3; k++) {
	if(k == i) continue;
	c[m++] = k;
    }
    for(k = m = 0; k < 3; k++) {
	if(k == j) continue;
	r[m++] = k;
    }
    return f * (a[c[0] * 3 + r[0]] * a[c[1] * 3 + r[1]] - a[c[1] * 3 + r[0]] * a[c[0] * 3 + r[1]]);
}

plane plth3pts(ptin3d pt[])
{
    int i, j, a[9];
    plane pl;

    for(i = j = 0; i < 3; i++) {
	a[j++] = pt[i].x;
	a[j++] = pt[i].y;
	a[j++] = pt[i].z;
    }
    pl.a = adjm(a, 0, 0) + adjm(a, 1, 0) + adjm(a, 2, 0);
    pl.b = adjm(a, 0, 1) + adjm(a, 1, 1) + adjm(a, 2, 1);
    pl.c = adjm(a, 0, 2) + adjm(a, 1, 2) + adjm(a, 2, 2);
    pl.d = a[0] * adjm(a, 0, 0) + a[3] * adjm(a, 1, 0) + a[6] * adjm(a, 2, 0);
    return pl;
}

int gcd(int a, int b)
{
    if(a == 0) {
	if(b > 0) return b;
	else return -b;
    }
    if(a < 0) a = -a;
    if(b < 0) b = -b;
    if(b >= a) b %= a;
    for(;;) {
	if(b == 0) return a;
	a %= b;
	if(a == 0) return b;
	b %= a;
    }
}

main(int argc, char *argv[])
{
    int i, j, n = 3, s, gd;
    ptin3d pt[3], pt2;
    plane pl;

    if(argc > 1) {
	n = atoi(argv[1]);
	if(n < 3) exit(0);
    }
    for(i = 0; i < 3; i++) scanf("%d%d%d", &pt[i].x, &pt[i].y, &pt[i].z);
    for(i = 0; i < 3; i++) printf("(%d, %d, %d) ", pt[i].x, pt[i].y, pt[i].z);
    pl = plth3pts(pt);
    if((pl.a == 0) && (pl.b == 0) && (pl.c == 0)) {
	printf("are on line\n");
	exit(0);
    }
    gd = gcd(gcd(pl.a, pl.b), gcd(pl.c, pl.d));
    if(gd > 0) {
	pl.a /= gd; pl.b /= gd; pl.c /= gd; pl.d /= gd;
    }
    printf("are on the plane\t %dx + %dy + %dz = %d\n", pl.a, pl.b, pl.c, pl.d);
    for(i = 3; i < n; i++) {
	scanf("%d%d%d", &pt2.x, &pt2.y, &pt2.z);
	printf("(%d, %d, %d)\t%d ", pt2.x, pt2.y, pt2.z, s = pl.a * pt2.x + pl.b * pt2.y + pl.c * pt2.z);
	if(s == pl.d) printf("= ");
	else if(s < pl.d) printf("< ");
	else printf("> ");
	printf("%d\n", pl.d);
    }
    return 0;
}
