#include <stdio.h>
#include <stdlib.h>
#include<math.h>

#define STEP 101

int adp = 1, m, n, m0, n0, f0 = 1., f1 = 1.;

void display1(int f)
{
    int i, k;
    double t, x, y, s;

    f1 = f0 * f;
    for(s = 0.; s < 1.; s += .01) {
	printf("active %d\nclear %d\n", adp, adp);
	printf("color 0 0 0\nText 5 20 x = ");
	if(f0 < 0) printf("-"); 
	printf("%3.1f cos %dt ", 1. - s, m);
	if(f1 > 0) printf("+");
	else printf("-");
	printf(" %3.1f cos %dt\n", s, m0);
/*
	printf("disk %f 0 .03\n", s * f1 + (1. - s) * f0);
*/
	printf("connect %f -0.1 %f 0. %f -0.1\n", s * f1 + (1. - s) * f0 - .03, s * f1 + (1. - s) * f0, s * f1 + (1. - s) * f0 + .03);
	printf("Text 300 20 y = sin %dt\ncolor 3 0 0\n", n);
        printf("connect");
        for(t = 0., k = i = 0; t < 2 * M_PI; t += .01, i++, k++) {
	    printf(" %f %f", x = f1 * s * cos(m0 * t) + f0 * (1. - s) * cos(m * t), y = sin(n * t));
	    if(i == 10) {
	        printf("\nconnect %f %f", x, y);
		i = 0;
	    }
	    if((k % STEP) == 0) {
		printf("\n");
		if(k == STEP) printf("color 2 1 0\n");
		else if(k == 2 * STEP) printf("color 1 2 0\n");
		else if(k == 3 * STEP) printf("color 0 3 0\n");
		else if(k == 4 * STEP) printf("color 0 2 1\n");
		else if(k == 5 * STEP) printf("color 0 1 2\n");
		else if(k == 6 * STEP) printf("color 0 0 3\n");
		else if(k == 7 * STEP) printf("color 1 0 2\n");
		else if(k == 8 * STEP) printf("color 2 0 1\n");
		printf("connect %f %f", x, y);
	    }
	}
	printf("\n");
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    f0 = f1;
    return;
}

void display2(void)
{
    int i, k;
    double t, x, y, s;

    for(s = 0.; s < 1.; s += .01) {
	printf("active %d\nclear %d\n", adp, adp);
	printf("color 0 0 0\nText 5 20 x = ");
	if(f0 < 0) printf("-");
	printf("cos %dt\n", m);
/*
	printf("disk %f 0 .03\n", s * f1 + (1. - s) * f0);
*/
	printf("connect %f -0.1 %f 0. %f -0.1\n", s * f1 + (1. - s) * f0 - .03, s * f1 + (1. - s) * f0, s * f1 + (1. - s) * f0 + .03);
	printf("Text 300 20 y = %3.1f sin %dt + %3.1f sin %dt\ncolor 3 0 0\n", 1 - s, n, s, n0);
        printf("connect");
        for(t = 0, k = i = 0; t < 2 * M_PI; t += .01, i++, k++) {
	    printf(" %f %f", x = f0 * cos(m * t), y = s * sin(n0 * t) + (1. - s) * sin(n * t));
	    if(i == 10) {
	        printf("\nconnect %f %f", x, y);
		i = 0;
	    }
	    if((k % STEP) == 0) {
		printf("\n");
		if(k == STEP) printf("color 2 1 0\n");
		else if(k == 2 * STEP) printf("color 1 2 0\n");
		else if(k == 3 * STEP) printf("color 0 3 0\n");
		else if(k == 4 * STEP) printf("color 0 2 1\n");
		else if(k == 5 * STEP) printf("color 0 1 2\n");
		else if(k == 6 * STEP) printf("color 0 0 3\n");
		else if(k == 7 * STEP) printf("color 1 0 2\n");
		else if(k == 8 * STEP) printf("color 2 0 1\n");
		printf("connect %f %f", x, y);
	    }
	}
	printf("\n");
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return;
}

main(int argc, char *argv[])
{
    int i, k;
    double t, x, y, s;

    if(argc > 1) m = atoi(argv[1]);
    else m = 3;
    if(argc > 2) n = atoi(argv[2]);
    else n = 1;
    if(m < 1 || (m % 2) == 0) exit(0);
    if(n < 1 || (n % 2) == 0) exit(0);
    if(gcd(m, n) > 1) exit(0);
    printf("color 0 0 0\nText 5 20 x = cos %dt\n", m);
/*
    printf("disk 1. 0. .03\n");
*/
    printf("connect .97 -.1 1. 0. 1.03 -.1\n");
    printf("Text 300 20 y = sin %dt\ncolor 3 0 0\n", n);
    printf("connect");
    for(t = 0., k = i = 0; t < 2 * M_PI; t += .01, i++, k++) {
	printf(" %f %f", x = cos(m * t), y = sin(n * t));
	if(i == 10) {
	    printf("\nconnect %f %f", x, y);
	    i = 0;
	}
	if((k % STEP) == 0) {
	    printf("\n");
	    if(k == STEP) printf("color 2 1 0\n");
	    else if(k == 2 * STEP) printf("color 1 2 0\n");
	    else if(k == 3 * STEP) printf("color 0 3 0\n");
	    else if(k == 4 * STEP) printf("color 0 2 1\n");
	    else if(k == 5 * STEP) printf("color 0 1 2\n");
	    else if(k == 6 * STEP) printf("color 0 0 3\n");
	    else if(k == 7 * STEP) printf("color 1 0 2\n");
	    else if(k == 8 * STEP) printf("color 2 0 1\n");
	    printf("connect %f %f", x, y);
	}
    }
    printf("\npause\n");
    for( ; ; ) {
/*
	fprintf(stderr, "%d %d\n", m, n);
*/
	if(m > n) {
	    m0 = m % n;
	    if(m0 == 0) m0 = 1;
	    if((m0 % 2) == 0) m0 = n - m0;
	    if(((m - m0) % 4) == 0) display1(1);
	    else display1(-1);
	    if(n == 1) break;
	    m = m0;
        }
	else {
	    n0 = n % m;
	    if(n0 == 0) n0 = 1;
	    if((n0 % 2) == 0) n0 = m - n0;
	    display2();
	    if(m == 1) break;
	    n = n0;
        }
    }
    return 0;
}
