#include <stdio.h>
#include <math.h>

typedef struct pointin2d {
    double x, y;
} P2D;

typedef struct line {
    double a, b, c;
} LINE;

typedef struct circle {
    double x, y, r;
} CIRC;

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}

LINE line(P2D pt1, P2D pt2)
{
    LINE ln;

    ln.a = pt2.y - pt1.y;
    ln.b = pt1.x - pt2.x;
    ln.c = pt1.x * pt2.y - pt1.y * pt2.x;
    return ln;
}

void gaishin(P2D pt1, P2D pt2, P2D pt3, CIRC *pt0)
{
    double d, x, y, a11, a12, a21, a22, b1, b2;

    a11 = pt1.x - pt2.x;
    a12 = pt1.y - pt2.y;
    b1 = (pt1.y * pt1.y - pt2.y * pt2.y + pt1.x * pt1.x - pt2.x * pt2.x) / 2.;
    a21 = pt1.x - pt3.x;
    a22 = pt1.y - pt3.y;
    b2 = (pt1.y * pt1.y - pt3.y * pt3.y + pt1.x * pt1.x - pt3.x * pt3.x) / 2.;
    if((d = a11 * a22 - a12 * a21) == 0.) exit(0);
    (*pt0).x = (b1 * a22 - b2 * a12) / d;
    (*pt0).y = (a11 * b2 - a21 * b1) / d;
    x = pt1.x - (*pt0).x;
    y = pt1.y - (*pt0).y;
    (*pt0).r = sqrt(x * x + y * y);
}

main(int argc, char *argv[])
{
    int i;
    double s[6], x, y, x2, y2;
    P2D a[7], p, q, r;
    LINE ln[6], m;
    CIRC crl;

    s[0] = .5 * M_PI; s[1] = 1.1 * M_PI; s[2] = .25 * M_PI;
    s[3] = 1.4 * M_PI; s[4] = .7 * M_PI; s[5] = 1.8 * M_PI;
    for(i = 0; i < 6; i++) {
        a[i].x = cos(s[i]);
	a[i].y = sin(s[i]);
    }
    printf("circle 0 0 1\n");
    a[6] = a[0];
    for(i = 0; i < 6; i++) {
        printf("connect %f %f %f %f\n", a[i].x, a[i].y, a[i + 1].x, a[i + 1].y);
	ln[i] = line(a[i], a[i + 1]);
	/*
	printf("line %f %f %f\n", ln[i].a, ln[i].b, -ln[i].c);
	*/
    }
    kouten(ln[0], ln[3], &p);
    printf("color 0 0 3\ndisk %f %f .02\n", p.x, p.y);
    kouten(ln[2], ln[5], &r);
    printf("color 0 0 3\ndisk %f %f .02\n", r.x, r.y);
    gaishin(a[0], a[3], r, &crl);
    printf("circle %f %f %f\n", crl.x, crl.y, crl.r);
    /*
    m = line(p, r);
    printf("color 3 0 0\nline %f %f %f\n", m.a, m.b, -m.c);
    */
    if(ln[3].b == 0.) {
        x = a[3].x;
	y = 2 * crl.y - a[3].y;
    }
    else {
        x = 2 * (ln[3].b * ln[3].b * crl.x + ln[3].a * ln[3].c - ln[3].a * ln[3].b * crl.y) / (ln[3].a * ln[3].a + ln[3].b * ln[3].b) - a[3].x;
	y = (-ln[3].a * x + ln[3].c) / ln[3].b;
    }
    printf("color 0 0 0\nconnect %f %f %f %f\n", x, y, a[4].x, a[4].y);
    printf("color 0 3 0\nconnect %f %f %f %f\n", x, y, r.x, r.y);
    if(ln[1].b == 0.) {
        x = a[0].x;
	y = 2 * crl.y - a[0].y;
    }
    else {
        x2 = 2 * (ln[0].b * ln[0].b * crl.x + ln[0].a * ln[0].c - ln[0].a * ln[0].b * crl.y) / (ln[0].a * ln[0].a + ln[0].b * ln[0].b) - a[0].x;
	y2 = (-ln[0].a * x2 + ln[0].c) / ln[0].b;
    }
    printf("color 0 0 0\nconnect %f %f %f %f\n", x2, y2, a[1].x, a[1].y);
    printf("color 0 3 0\nconnect %f %f %f %f\n", x2, y2, r.x, r.y);
    printf("connect %f %f %f %f\n", x2, y2, x, y);
    printf("connect %f %f %f %f\n", a[1].x, a[1].y, a[4].x, a[4].y);
    return 0;
}
