#include <stdio.h>
#include <stdlib.h>

#define DIM 3
#define GEN 4
#define MD 16
#define MN 2000

int n = 0;
double a[MN][DIM];

int alex(double f[])
{
    int i, j;
    double t;

    for(i = 0; i < n; i++) {
      for(j = 0;j < DIM; j++) if((t = a[i][j] - f[j]) * t > .1) break;
	if(j == DIM) return i;
    }
    for(j = 0; j < DIM; j++) a[n][j] = f[j];
    n++;
    if(n >= MN) exit(0);
    return -1;
}

void ex(double e1[DIM], double e2[DIM], double e3[DIM], double e4[DIM], int k, int depth)
{
    double f[DIM], g[DIM]; 
    int i;

    if(depth++ == MD) return;
    for(i = 0; i < DIM; i++) f[i] = e1[i] + e2[i] + e3[i] + e4[i];
    if(alex(f) >= 0) return;
    printf("connect %f %f %f %f %f %f %f %f %f %f\n", e1[0] / e1[2], e1[1] / e1[2], e2[0] / e2[2], e2[1] / e2[2], e3[0] / e3[2], e3[1] / e3[2], e4[0] / e4[2], e4[1] / e4[2], e1[0] / e1[2], e1[1] / e1[2]);
    if(k != 1) {
        for(i = 0; i < DIM; i++) f[i] = (3 * e3[i] - e4[i]) / 2. + 2 * e2[i];
        for(i = 0; i < DIM; i++) g[i] = - e4[i] + 2 * e2[i] + 4 * e3[i];
	ex(f, e2, e3, g, 1, depth);
    }
    if(k != 2) {
        for(i = 0; i < DIM; i++) f[i] = (3 * e4[i] - e3[i]) / 2. + 2 * e1[i];
        for(i = 0; i < DIM; i++) g[i] = - e3[i] + 2 * e1[i] + 4 * e4[i];
	ex(e1, f, g, e4, 2, depth);
    }
    if(k != 3) {
      for(i = 0; i < DIM; i++) f[i] = - e1[i] + (e3[i] + 3 * e4[i]) / 2.;
      for(i = 0; i < DIM; i++) g[i] = - e2[i] + (e4[i] + 3 * e3[i]) / 2.;
	ex(f, g, e3, e4, 3, depth);
    }
    return;
}

main()
{
    int i;
    double e1[DIM], e2[DIM], e3[DIM], e4[DIM];

    e1[0] = e3[1] = e4[1] = 0;
    e1[1] = e1[2] = e2[0] = e2[1] = e2[2] = 1;
    //    e3[0] = e3[2] = e4[2] = 1; e4[0] = -1;
    e4[0] = 0; e3[2] = e4[2] = 1; e3[0] = 2;
    ex(e1, e2, e3, e4, 0, 0);
    return 0;
}
