#include <stdio.h>
#include <math.h>

#define MAXPT 10

int n;
double cx[MAXPT], cy[MAXPT];

double hantei(double x, double y)
{
    int i;
    double s = 1., x0, y0;

    for(i = 0; i < n; i++) {
        x0 = x - cx[i];
	y0 = y - cy[i];
	s *= sqrt(x0 * x0 + y0 * y0);
    }
    return s;
}

main(int argc, char *argv[])
{
    int i;
    double x, y, s, d, x0, y0;

    if(argc > 1) {
	n = atoi(argv[1]);
	if(n > MAXPT || n < 2) exit(0);
    }
    else n = 2;
    for(i = 0; i < n; i++) {
	cx[i] = cos(2. * i * M_PI / n);
	cy[i] = sin(2. * i * M_PI / n);
    }
    for(x = -2.; x < 2.; x += .004) {
	for(y = -2.; y < 2.; y += .004) {
       	    if(hantei(x, y) < 1.) {
	        printf("point %f %f\n", x, y);
	    }
	}
    }
    printf("color 0 0 3\n");
    for(i = 0; i < n; i++) printf("disk %f %f .02\n", cx[i], cy[i]);
    return 0;
}
