#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXPT 10

int n;
double cx[MAXPT], cy[MAXPT], s0;

hantei(double x, double y)
{
    int i;
    double s = 1., x0, y0;

    for(i = 0; i < n; i++) {
        x0 = x - cx[i];
	y0 = y - cy[i];
	s *= sqrt(x0 * x0 + y0 * y0);
    }
    if(s < s0) return 1;
    else return 0;
}

main(int argc, char *argv[])
{
    int i, f, f0;
    double x, y, x0, y0;

    if(argc > 1) {
	n = atoi(argv[1]);
	if(n > MAXPT || n < 2) exit(0);
    }
    else n = 2;
    if(argc > 1) {
	s0 = atof(argv[2]);
    }
    else s0 = 1.;
    for(i = 0; i < n; i++) {
	cx[i] = cos(2. * i * M_PI / n);
	cy[i] = sin(2. * i * M_PI / n);
    }
    for(x = -2.; x < 2.; x += .005) {
      f = hantei(x, -2.);
	for(y = -2.; y < 2.; y += .005) {
       	    if((f0 = hantei(x, y)) != f) {
	        printf("point %f %f\n", x, y);
		f = f0;
	    }
	}
    }
    for(y = -2.; y < 2.; y += .005) {
      f = hantei(-2., y);
	for(x = -2.; x < 2.; x += .005) {
       	    if((f0 = hantei(x, y)) != f) {
	        printf("point %f %f\n", x, y);
		f = f0;
	    }
	}
    }
    printf("color 0 0 3\n");
    for(i = 0; i < n; i++) printf("disk %f %f .02\n", cx[i], cy[i]);
    return 0;
}
