#include <stdio.h>
#include <math.h>

typedef struct pointin2d {
    double x, y;
} P2D;

typedef struct line {
    double a, b, c;
} LINE;

P2D u[4], v[4], w[4], a0, b0;
LINE l0, l1, l2, m, m2;

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}

LINE line(P2D pt1, P2D pt2)
{
    LINE ln;

    ln.a = pt2.y - pt1.y;
    ln.b = pt1.x - pt2.x;
    ln.c = pt1.x * pt2.y - pt1.y * pt2.x;
    return ln;
}

void draw(void)
{
    int i;
	
    printf("color 0 3 0\n");
	for(i = 0; i < 4; i++) {
            m = line(a0, u[i]);
	    printf("line %f %f %f\n", m.a, m.b, -m.c);
	    kouten(m, l1, v + i);
	    printf("disk %f %f .2\n", v[i].x, v[i].y);
	}
	printf("color 3 0 0\n");
	m = line(v[1], w[1]);
	m2 = line(v[2], w[2]);
	printf("line %f %f %f\n", m.a, m.b, -m.c);
	printf("line %f %f %f\n", m2.a, m2.b, -m2.c);
	kouten(m, m2, &b0);
	m = line(v[3], b0);
	printf("line %f %f %f\n", m.a, m.b, -m.c);
	kouten(m, l2, w + 3);
	printf("color 0 0 3\ndisk %f %f .2\n", w[3].x, w[3].y);
}

main()
{
    int i, adp = 1;

    u[0].x = -5.; u[1].y = -2.; u[2].x = 3.; u[3].x = 9.;
    u[0].y = u[1].y = u[2].y = u[3].y = -10.;
    w[0].x = -5.; w[1].x = 8.; w[2].x = 0.;
    for(i = 0; i < 3; i++) w[i].y = w[i].x + 10.;
    a0.x = -5.; a0.y = -23.;
    l0.a = 0.; l0.b = 1.; l0.c = -10.;
    l1.a = -.5; l1.b = 1.; l1.c = 7.5;
    l2.a = 1.; l2.b = -1.; l2.c = -10.;
    printf("line %f %f %f\n", l0.a, l0.b, -l0.c);
    printf("line %f %f %f\n", l2.a, l2.b, -l2.c);
    printf("color 0 0 3\n");
    for(i = 0; i < 4; i++) printf("disk %f %f .2\n", u[i].x, u[i].y);
    for(i = 0; i < 3; i++) printf("disk %f %f .2\n", w[i].x, w[i].y);
    printf("active 1\ncopy 0 1\ncolor 0 0 0\nline %f %f %f\n", l1.a, l1.b, -l1.c);
    draw();
    printf("display 1\npause\n");
    adp = 2;
    for(l1.a = -.5; l1.a < .7; l1.a += .01) {
        l1.c = -5.* l1.a + 5. * l1.b;
	printf("copy 0 %d\ncolor 0 0 0\nline %f %f %f\n", adp, l1.a, l1.b, -l1.c);
	draw();
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\n", adp);
    }
    printf("active 0\ncolor 0 0 0\nline %f %f %f\npause\nactive %d\n", l1.a, l1.b, -l1.c, adp);
    for(; a0.y < -1.; a0.y += .05) {
	printf("copy 0 %d\n", adp);
	draw();
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\n", adp);
    }
    return 0;
}
