#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 10

typedef struct eqnofline {
	double a, b, c;
} LINE;

LINE l[MAXN];

main(int argc, char *argv[])
{
    int i, j, n;
    double t;

    n = argc - 1;
    if(n < 3 || n > MAXN) exit(0);
    for(i = 0; i < n; i++) {
	t = atof(argv[i + 1]);
	l[i].a = cos(t);
	l[i].b = sin(t);
	l[i].c = 1.;
    }
    printf("circle 0. 0. 1.\ncolor 0 0 3\n");
    for( i = 0; i < n; i++) printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    printf("color 3 0 0\ncurve ");
    for(i = 0; i < n; i++) {
	for(j = 0; j < n; j++) {
	    if(j == i) continue;
	    printf("(%fx+%fy+%f)", l[j].a, l[j].b, -l[j].c);
	}
	if(i < n - 1) printf("+");
	else printf("\n");
    }
    return 0;
}
