#include <stdio.h>
#include <math.h>

int m = 1, l = 2;

double f1(double t)
{
    return -m * sin(m * t);
}

double g1(double t)
{
    return l * cos(l * t);
}

double f2(double t)
{
    return -m * m * cos(m * t);
}

double g2(double t)
{
    return -l * l * sin(l * t);
}

double ft(double t)
{
    double x = f1(t), y = g1(t);
    return (g2(t) * x - f2(t) * y) / (x * x + y * y);
}

main(int argc, char *argv[])
{
    int n = 10000;
    double a = 0., b = 2 * M_PI, dx = (b - a) / n, s = 0., x;

    if(argc > 1) m = atoi(argv[1]);
    if(argc > 2) l = atoi(argv[2]);
    for(x = a; x < b; x += dx) s += ft(x);
    s *= dx;
    fprintf(stderr, "%f\n", s);
    return 0;
}
