#include "geometry.h"
#include <stdio.h>
#define MD 3

void connect(P2D a, P2D b)
{
    printf("connect %f %f %f %f\n", a.x, a.y, b.x, b.y);
    return;
}

P2D midpt(P2D a, P2D b)
{
    P2D m;

    m.x = (a.x + b.x) / 2.;
    m.y = (a.y + b.y) / 2.;
    return m;
}

P2D symp(P2D a, P2D b)
{
    P2D c;

    c.x = 2. * a.x - b.x;
    c.y = 2. * a.y - b.y;
    return c;
}

void ex(P2D a, P2D b, P2D c, P2D d, int depth)
{
    P2D m;

    connect(b, c);
    connect(c, d);
    connect(d, a);
    if(depth == MD) return;
    depth++;
    m = midpt(b, c);
    ex(c, b, symp(m, d), symp(m, a), depth);
    m = midpt(c, d);
    ex(d, c, symp(m, a), symp(m, b), depth);
    return;
}

main()
{
    P2D a, b, c, d, m;

    a.x = a.y = b.y = 0.;
    b.x = d.y = 1.; d.x = -.1;
    c.x = 1.2; c.y = .9;
    connect(a, b);
    connect(b, c);
    connect(c, d);
    connect(d, a);
    m = midpt(a, b);
    ex(b, a, symp(m, c), symp(m, d), 0);
    m = midpt(b, c);
    ex(c, b, symp(m, d), symp(m, a), 0);
    m = midpt(c, d);
    ex(d, c, symp(m, a), symp(m, b), 0);
    return 0;
}
