#include <stdio.h>
#include <math.h>

#define SCALE 8.

struct POINTin3D {
    double x, y, z;
} u[8];

struct POINTin2D {
    double x, y;
} p[8];

struct POINTin2D sptopl(struct POINTin3D u)
{
    struct POINTin2D p;

    p.x = u.x * exp(-u.z / SCALE);
    p.y = u.y * exp(-u.z / SCALE);
    return p;
}

main()
{
    int i, adp = 1;
    double s, y1, y2;

    for(i = 0; i < 4; i++) u[i].y = -2.;
    for(i = 4; i < 8; i++) u[i].y = 2.;
    for(s = -M_PI / 3.; s < -.1; s += .003) {
	printf("active %d\nclear\n", adp);
	u[0].x = u[4].x = 3. * sin(s); u[0].z = u[4].z = -3. * cos(s) + 3.;
	u[1].x = u[5].x = 3. * cos(s); u[1].z = u[5].z = 3. * sin(s) + 3.;
	u[2].x = u[6].x = -3. * cos(s); u[2].z = u[6].z = -3. * sin(s) + 3.;
	u[3].x = u[7].x = -3. * sin(s); u[3].z = u[7].z = 3. * cos(s) + 3.;
	for(i = 0; i < 8; i++) p[i] = sptopl(u[i]);
	printf("connect %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f\n", p[0].x, p[0].y, p[4].x, p[4].y, p[5].x, p[5].y, p[1].x, p[1].y, p[0].x, p[0].y);
	if(p[0].x < p[2].x) printf("connect %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f\n", p[2].x, p[2].y, p[6].x, p[6].y, p[7].x, p[7].y, p[3].x, p[3].y, p[2].x, p[2].y);
	else {
	    if(p[2].x == p[3].x) {
		y1 = p[2].y;
		y2 = p[6].y;
	    }
	    else {
		y1 = p[3].y + (p[2].y - p[3].y) * (p[0].x - p[3].x) / (p[2].x - p[3].x);
		y2 = p[7].y + (p[6].y - p[7].y) * (p[4].x - p[7].x) / (p[6].x - p[7].x);

	    }
	    printf("connect %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f\n", p[0].x, y1, p[3].x, p[3].y, p[7].x, p[7].y, p[0].x, y2);
	    printf("connect %3.2f %3.2f %3.2f %3.2f\n", p[2].x, p[2].y, p[6].x, p[6].y);
	}
	printf("connect %3.2f %3.2f %3.2f %3.2f\n", p[0].x, p[0].y, p[2].x, p[2].y);
	printf("connect %3.2f %3.2f %3.2f %3.2f\n", p[1].x, p[1].y, p[3].x, p[3].y);
	printf("connect %3.2f %3.2f %3.2f %3.2f\n", p[4].x, p[4].y, p[6].x, p[6].y);
	printf("connect %3.2f %3.2f %3.2f %3.2f\n", p[5].x, p[5].y, p[7].x, p[7].y);
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
