#include <stdio.h>
#include <math.h>

#define MAXN 100

double x[MAXN], y[MAXN], cx[MAXN], cy[MAXN];
int ac[MAXN * MAXN], cn;

double distance(int i, int j)
{
    double xx, yy;

    xx = x[i] - x[j];
    yy = y[i] - y[j];
    return sqrt(xx * xx + yy * yy);
}

double gaishin(int i, int j, int k, double *x0, double *y0)
{
    double d, rad, xx, yy, a11, a12, a21, a22, b1, b2;

    a11 = x[i] - x[j];
    a12 = y[i] - y[j];
    b1 = (y[i] * y[i] - y[j] * y[j] + x[i] * x[i] - x[j] * x[j]) / 2.;
    a21 = x[i] - x[k];
    a22 = y[i] - y[k];
    b2 = (y[i] * y[i] - y[k] * y[k] + x[i] * x[i] - x[k] * x[k]) / 2.;
    if((d = a11 * a22 - a12 * a21) == 0.) return 0.;
    *x0 = (b1 * a22 - b2 * a12) / d;
    *y0 = (a11 * b2 - a21 * b1) / d;
    xx = x[i] - *x0;
    yy = y[i] - *y0;
    return sqrt(xx * xx + yy * yy);
}

main(int argc, char *argv[])
{
    int n, i, j, k, l;
    double rad, x0, y0;

    if(argc > 1) n = atoi(argv[1]);
    else n = 3;
    if(n >= MAXN) exit(0);
    for(i = 0; i < n; i++) scanf("%lf%lf", x + i, y + i);
    for(i = 0; i < n - 2; i++) {
        for(j = i + 1; j < n - 1; j++) {
	   for(k = j + 1; k < n; k++) {
	       if((rad = gaishin(i, j, k, x + n, y + n)) == 0.) continue;
	       for(l = 0; l < n; l++) {
		   if(l == i || l == j || l == k) continue;
		   if(distance(l, n) <= rad) break;
	       }
	       if(l == n) {
		 printf("%d %d %d ܤΰ (%f, %f) ܤ롣Ⱦ¤ %f\n", i, j, k, x[n], y[n], rad);
	       }
	   }
	}
    }
    return 0;
}
