#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 100

double x[MAXN], y[MAXN], cx[MAXN], cy[MAXN];
int ac[MAXN * MAXN], cn;

double distance(int i, int j)
{
    double xx, yy;

    xx = x[i] - x[j];
    yy = y[i] - y[j];
    return sqrt(xx * xx + yy * yy);
}

double gaishin(int i, int j, int k, double *x0, double *y0)
{
    double d, rad, xx, yy, a11, a12, a21, a22, b1, b2;

    a11 = x[i] - x[j];
    a12 = y[i] - y[j];
    b1 = (y[i] * y[i] - y[j] * y[j] + x[i] * x[i] - x[j] * x[j]) / 2.;
    a21 = x[i] - x[k];
    a22 = y[i] - y[k];
    b2 = (y[i] * y[i] - y[k] * y[k] + x[i] * x[i] - x[k] * x[k]) / 2.;
    if((d = a11 * a22 - a12 * a21) == 0.) return 0.;
    *x0 = (b1 * a22 - b2 * a12) / d;
    *y0 = (a11 * b2 - a21 * b1) / d;
    xx = x[i] - *x0;
    yy = y[i] - *y0;
    return sqrt(xx * xx + yy * yy);
}

main(int argc, char *argv[])
{
    int n, i, j, k, l;
    double rad, x0, y0;

    if(argc > 1) n = atoi(argv[1]);
    else n = 3;
    if(n >= MAXN) exit(0);
    for(i = 0; i < n; i++) scanf("%lf%lf", x + i, y + i);
    for(i = 0; i < n; i++) printf("disk %f %f .2\n", x[i], y[i]);
    for(i = 0; i < MAXN * MAXN; i++) ac[i] = -1;
    cn = 0;
    for(i = 0; i < n - 2; i++) {
        for(j = i + 1; j < n - 1; j++) {
	   for(k = j + 1; k < n; k++) {
/*
	       printf("(%f, %f)\n", x[i], y[i]);
	       printf("(%f, %f)\n", x[j], y[j]);
	       printf("(%f, %f)\n", x[k], y[k]);
	       if((rad = gaishin(i, j, k, &x0, &y0)) == 0.) {
		   printf("ϰľˤ롣\n");
	       }
	       else {
		   printf("γ (%f, %f) Ⱦ¤ %f\n", x0, y0, rad);
	       }
*/
	       if((rad = gaishin(i, j, k, x + n, y + n)) == 0.) continue;
	       for(l = 0; l < n; l++) {
		   if(l == i || l == j || l == k) continue;
		   if(distance(l, n) <= rad) break;
	       }
	       if(l == n) {
/*		 printf("%d %d %d ܤΰ (%f, %f) ܤ롣Ⱦ¤ %f\n", i, j, k, x[n], y[n], rad);
*/
		   cx[cn] = x[n]; cy[cn] = y[n];
		   if((l = ac[i * n + j]) == -1) {
		       ac[i * n + j] = cn;
		       printf("color 0 0 3\nconnect %f %f %f %f\n", x[i], y[i], x[j], y[j]);
		   }
		   else {
		       printf("color 3 0 0\nconnect %f %f %f %f\n", cx[l], cy[l], x[n], y[n]);
		       ac[i * n + j] = -1;
		   }
		   if((l = ac[i * n + k]) == -1) {
		       ac[i * n + k] = cn;
		       printf("color 0 0 3\nconnect %f %f %f %f\n", x[k], y[k], x[i], y[i]);
		   }
		   else {
		       printf("color 3 0 0\nconnect %f %f %f %f\n", cx[l], cy[l], x[n], y[n]);
		       ac[i * n + k] = -1;
		   }
		   if((l = ac[j * n + k]) == -1) {
		       ac[j * n + k] = cn;
		       printf("color 0 0 3\nconnect %f %f %f %f\n", x[k], y[k], x[j], y[j]);
		   }
		   else {
		       printf("color 3 0 0\nconnect %f %f %f %f\n", cx[l], cy[l], x[n], y[n]);
		       ac[j * n + k] = -1;
		   }
		   cn++;
	       }
	   }
	}
    }
    printf("color 3 0 0\n");
    for(i = 0; i < n - 1; i++) {
       for(j = i + 1; j < n; j++) {
	   if((l = ac[i * n + j]) == -1) continue;
	   x0 = (x[i] + x[j]) / 2.; y0 = (y[i] + y[j]) / 2.;
	   rad = (x[i] - x0) * (x[i] - x0) + (y[i] - y0) * (y[i] - y0);
	   for(k = 0; k < n; k++) {
	       if(k == i || k == j) continue;
	       if(((x[k] - x0) * (x[k] - x0) + (y[k] - y0) * (y[k] - y0)) < rad) break;
	   }
	   if(k == n) printf("connect %f %f %f %f\n", cx[l], cy[l], 10 * x0 - 9 * cx[l], 10 * y0 - 9 * cy[l]);
	   else printf("connect %f %f %f %f\n", cx[l], cy[l], 10 * cx[l] - 9 * x0, 10 * cy[l] - 9 * y0);
       }
    }
    return 0;
}
