#include <stdio.h>
#include <math.h>

#define MAXN 100
typedef struct {
    double x, y;
} PT;

PT pt[MAXN], tpt[MAXN];
int m;

PT gaisin(PT p1, PT p2, PT p3)
{
    PT p0;
    double t1 = (p1.y * p1.y - p2.y * p2.y + p1.x * p1.x - p2.x * p2.x)/2., t2 = (p1.y * p1.y - p3.y * p3.y + p1.x * p1.x - p3.x * p3.x)/2.;

    p0.x = (t1 * (p1.y - p3.y) - t2 * (p1.y - p2.y)) / ((p1.x - p2.x) * (p1.y - p3.y) - (p1.x - p3.x) * (p1.y - p2.y));
    p0.y = (t1 * (p1.x - p3.x) - t2 * (p1.x - p2.x)) / ((p1.x - p3.x) * (p1.y - p2.y) - (p1.x - p2.x) * (p1.y - p3.y));
    return p0;
}

double dstc(PT pt1, PT pt2)
{
    double x = pt1.x - pt2.x, y = pt1.y - pt2.y;

    return sqrt(x * x + y * y);
}

int check(int n, int t1, int t2, int t3)
{
    PT tpt0;
    int i;
    double mdt;

    tpt0 = gaisin(pt[t1], pt[t2], pt[t3]);
    if((mdt = dstc(pt[t1], tpt0)) > 1000. || mdt < -1000.) return -1;
    for(i = 0; i < n; i++) {
	if(i == t1 || i == t2 || i == t3) continue;
	if(dstc(tpt0, pt[i]) < mdt) return -1;
    }
    return 1;
}

void ex(int n, int t1, int t2, int t3, PT tpt0)
{
    int i, j;
    PT tpt2;
/*
    tpt0 = gaisin(pt[t1], pt[t2], pt[t3]);
*/
    for(i = 0; i < n ; i++) {
	if(i == t1 || i == t2 || i == t3) continue;
	if(check(n, t1, t2, i) > 0) break;
    }
    if(i == n) {
	printf("(%lf, %lf) - \n", tpt0.x, tpt0.y);
	return;
    }
    tpt2 = tpt[m] = gaisin(pt[t1], pt[t2], pt[i]);
    printf("connect %f %f %f %f\n", tpt0.x, tpt0.y, tpt[m].x, tpt[m].y);
/*
    printf("sleep\n");
    printf("(%lf, %lf) - (%lf, %lf)\n", tpt0.x, tpt0.y, tpt[m].x, tpt[m].y);
*/
    for(j = 0; j < m; j++) if(dstc(tpt[j], tpt[m]) < .001) return ;
    m++;
    ex(n, t1, i, t2, tpt2);
    ex(n, t2, i, t1, tpt2);
}

main(int argc, char *argv[])
{
/*
    PT p0, p1, p2, p3;
    
    p1.x = 1., p1.y = 1., p2.x = 2., p2.y = 3., p3.x = 3., p3.y = 2.;

    p0 = gaisin(p1, p2, p3);
    printf("(%lf, %lf)\n", p0.x, p0.y);
    printf("0-1 : %lf\n", dstc(p0, p1));
    printf("0-2 : %lf\n", dstc(p0, p1));
    printf("0-3 : %lf\n", dstc(p0, p1));

*/
    PT pt1, pt2, tpt0;
    int i, j, n, t1, t2, t3;
    double mdst, dst;

    if(argc == 1) exit(0);
    n = atoi(argv[1]);
    for(i = 0; i < n; i++) scanf("%lf%lf", &pt[i].x, &pt[i].y);
    for(mdst = dstc(pt[0], pt[1]), i = 0; i < n - 1; i++) {
	for(j = i + 1; j < n; j++) {
	    if(mdst > (dst = dstc(pt[i], pt[j]))) { 
		mdst = dst;
		t1 = i; t2 = j;
	    }
	}
    }
    printf("color 0 0 0\n");
    for(i = 0; i < n; i++) printf("disk %f %f .1\n", pt[i].x, pt[i].y);
    printf("color 3 0 0\n");
    pt[n].x = 50.; pt[n++].y = 0.; pt[n].x = -50.; pt[n++].y = 0.;
    pt[n].x = 0.; pt[n++].y = 50.; pt[n].x = 0.; pt[n++].y = -50.;
/*
    printf("The minimal distance is %lf (%d - %d)\n", mdst, t1, t2);
    for(mdst = 100., i = 0; i < n; i++) {
	if(i == t1 || i == t2) continue;
	tpt0 = gaisin(pt[t1], pt[t2], pt[i]);
	if((dst = dstc(tpt0, pt[i])) < mdst) {
	    mdst = dst;
	    t3 = i;
	    tpt[0] = tpt0;
	}
    }
*/
    for(i = 0; i < n ; i++) {
	if(i == t1 || i == t2) continue;
	if(check(n, t1, t2, i) > 0) break;
    }
    t3 = i; tpt[0] = gaisin(pt[t1], pt[t2], pt[t3]);
    printf("(%lf, %lf)\n", tpt[0].x, tpt[0].y);
    m = 1;
    ex(n, t1, t2, t3, tpt[0]);
/*
    pt1.x = 1.; pt1.y = 4.; pt2.x = 5.; pt2.y = 1.;
    printf("The distance is %lf\n", dstc(pt1,pt2));
*/
    return 0;
}
